<?php $__env->startSection('content'); ?>
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>Collection Commission Report</h4>
                    </div>
                </div>

            </div>
        </div>
        <!-- Top bar ends -->

        <!-- Main container starts -->
        <div class="main-container">
            <!-- Row starts -->
            <div class="row gutter">
                <div class="card">
                    <div class="card-body">
                        <form class="" action="#" id="report-filter">
                            <div class="row">
                                <div class="col-sm-3">
                                    <label>Invoice Date</label>
                                    <?php echo $__env->make(
                                        'xreports::common.report_date_range_select'
                                    , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>REP</label>
                                        <div class="form-group">
                                            
                                            <select name="rep_id" id="rep_id" class="form-control select2">
                                                <option value="">Select Rep</option>
                                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <option value="<?php echo e($role->id); ?>"><?php echo e($role->username); ?> - <?php echo e($role ->fname); ?></option>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-3">
                                    <div class="form-group">
                                        <label>Period</label>
                                        <div class="form-group">
                                            <input type="number" class="form-control" id="period" name="period"
                                                value="165">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-2">
                                    <br>
                                    <button id="generate_report_btn" class="btn btn-primary">
                                        <span id="spinner" hidden class="spinner-border spinner-border-sm" role="status"
                                            aria-hidden="true"></span> Generate
                                    </button>
                                </div>
                            </div>


                        </form>
                    </div>
                </div>
            </div>
            <!-- Row ends -->

        </div>
        <!-- Main container ends -->

    </div>
    <!-- Dashboard wrapper ends -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('include_js'); ?>
    <script src="<?php echo e(asset('/pramix/js/reports_js.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {
            $("#generate_report_btn").click(function(e) {
                $('#generate_report_btn').prop('disabled', true);
                $('#spinner').prop('hidden', false);
                var params = {
                    filter_details: $('#report-filter :input').serialize(),
                };
                e.preventDefault();
                $.ajax({
                    url: "<?php echo e(route('reports.generate_collection_commission_report')); ?>",
                    type: 'POST',
                    dataType: 'JSON',
                    data: $.param(params),
                    success: function(response) {
                        $('#generate_report_btn').prop('disabled', false);
                        $('#spinner').prop('hidden', true);
                        var url = response.report_url
                        window.open(url, '_blank');
                    },
                });
                e.preventDefault();
                return false;
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xreports/src/views/commission/index.blade.php ENDPATH**/ ?>