<?php $__env->startSection('include_css'); ?>
    <link href="<?php echo e(asset('/plugins/fineuploader/fine-uploader-gallery.min.css')); ?>" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dragula/3.7.2/dragula.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <?php if(isset($customer->id)): ?>
                            <h4><?php echo e(__('xcustomer::customer.headings.edit_customer')); ?></h4>
                        <?php else: ?>
                            <h4><?php echo e(__('xcustomer::customer.headings.new_customer')); ?></h4>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12" id="save_button_group">
                    <ul class="right-stats" id="save_button_group">
                        <button class="btn btn-primary"
                           id="customer-save-btn"><?php echo e(__('xcustomer::customer.buttons.save')); ?></button>
                        <button class="btn btn-primary"
                           id="customer-save-and-new"><?php echo e(__('xcustomer::customer.buttons.save_and_new')); ?></button>
                        <button class="btn btn-primary"
                           id="customer-update-btn"><?php echo e(__('xcustomer::customer.buttons.update')); ?></button>
                    </ul>
                </div>
            </div>
        </div>

        <div class="main-container">

            <form action="<?php echo e(url('/').'/customer'); ?>" method="POST" id="create_customer_form" >
                <?php echo csrf_field(); ?>
                <input type="hidden" name="customer_id" id="customer_id" value="<?php echo e($customer->id ?? ''); ?>">
                <input type="hidden" name="page" id="page" value="<?php echo e($page ?? ''); ?>">
                <input type="hidden" name="isajax" id="isajax" value="<?php echo e(Request::ajax()); ?>">
                <input type="hidden" name="ref_id" id="ref_id" value="<?php echo e($customer->id ?? ''); ?>">
                <input type="hidden" name="ref_type" id="ref_type" value="C">
                <input type="hidden" name="telephone_country" id="telephone_country" value="">
                <input type="hidden" name="mobile_country" id="mobile_country" value="">
                <input type="hidden" name="shipping_address_status" id="shipping_address_status"
                       value="<?php echo e($shipping_address_status ?? ''); ?>">
                <input type="hidden" name="add_as_company_name" id="add_as_company_name"
                       value="<?php echo e($customer->customer_type?? ''); ?>">

            <div class="row gutter">


                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                        <div class="card" id="customer-details-card">
                            <div class="card-header">
                                    <h4><?php echo e(__('xcustomer::customer.headings.panel_customer_details')); ?></h4>
                            </div>

                            <div class="card-body">
                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.business_name'), 'business_name', $customer->business_name ?? '', array( 'class' => 'form-control validate[required]' , 'id' => 'business_name'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formDropdown('Invoice type', 'invoice_type',getConfig('CUSTOMER_INVOICE_TYPES'),isset($customer->invoice_type) ? $customer->invoice_type : getConfigValue('CUSTOMER_INVOICE_TYPES'), array('class' => 'form-control', 'id' => 'customer_invoice_type'))); ?>


                                        

                                    </div>
                                </div>
                                <div class="row gutter" >
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.company_name'), 'company_name', $customer->company_name ?? '', array( 'class' => 'form-control validate[required]' , 'id' => 'company_name'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.mobile'), 'mobile', $customer->mobile ?? '', array( 'class' => 'form-control' , 'id' => 'customer_mobile'))); ?>

                                    </div>
                                </div>




                                <div class="row gutter">

                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.telephone'), 'telephone', $customer->telephone ?? '', array( 'class' => 'form-control' , 'id' => 'customer_telephone'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText('Fax', 'fax', $customer->fax ?? '', array( 'class' => 'form-control' , 'id' => 'fax'))); ?>

                                    </div>
                                </div>



                                <div class="row gutter">
                                    <div class="col-lg-2 col-md-2 col-sm-2 col-xs-4">
                                        <?php echo e(formDropdown(__('xcustomer::customer.labels.title'), 'title',getConfig('TITLE'),isset($customer->title) ? $customer->title : getConfigValue('TITLE'), array('class' => 'form-control', 'id' => 'title'))); ?>

                                    </div>
                                    <div class="col-lg-4 col-md-4 col-sm-4 col-xs-10">
                                        <?php echo e(formText(__('xcustomer::customer.labels.first_name'), 'first_name', $customer->fname ?? '', array( 'class' => 'form-control ' , 'id' => 'first_name'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.last_name'), 'last_name', $customer->lname ?? '', array( 'class' => 'form-control' , 'id' => 'last_name'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.nic'), 'nic', $customer->nic ?? '', array( 'class' => 'form-control' , 'id' => 'nic'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formDropdown('Customer Grade', 'customer_grade',getConfig('CUSTOMER_GRADE'),isset($customer->customer_grade) ? $customer->customer_grade : getConfigValue('CUSTOMER_GRADE'), array('class' => 'form-control', 'id' => 'customer_grade'))); ?>


                                        

                                    </div>
                                </div>

                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formEmail(__('xcustomer::customer.labels.email'), 'email', $customer->email ?? '', array( 'class' => 'form-control' , 'id' => 'customer_email'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.website'), 'website', $customer->website ?? '', array( 'class' => 'form-control' , 'id' => 'website'))); ?>

                                    </div>
                                </div>

                                <?php echo e(formTextArea(__('xcustomer::customer.labels.remarks'), 'customer_remarks', $customer->remarks ?? '', array( 'class' => 'form-control' , 'id' => 'customer_remarks', 'rows' => 3))); ?>


                            </div>
                        </div>
                        <div class="card" id="payment-details-card">
                            <div class="card-header">
                                <h4><?php echo e(__('xcustomer::customer.headings.panel_customer_payment_details')); ?></h4>
                            </div>

                            <div class="card-body">
                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label
                                                for="outstanding_amount"><?php echo e(__('xcustomer::customer.labels.outstanding_amount')); ?></label>
                                            <div class="input-group">
                                                <div class="input-group-addon">Rs.</div>
                                                <input type="text" class="form-control" id="outstanding_amount"
                                                       name="outstanding_amount"
                                                       value="<?php echo e($customer->outstanding_amount ?? ''); ?>" readonly>

                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.outstanding_limit'), 'outstanding_limit', $customer->outstanding_limit ?? 600000, array( 'class' => 'form-control validate[required]', 'id' => 'outstanding_limit'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.outstanding_day_limit'), 'outstanding_day_limit', $customer->outstanding_max_days ?? getConfig('OUTSTANDING_MAX_DAYS'), array( 'class' => 'form-control validate[required]', 'id' => 'outstanding_day_limit'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formText(__('xcustomer::customer.labels.tax_no'), 'tax_no', $customer->tax_no ?? '', array( 'class' => 'form-control' , 'id' => 'tax_no'))); ?>

                                    </div>

                                </div>

                                <div class="row gutter">
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formNumber(__('xcustomer::customer.labels.discount'), 'discount', $customer->discount ?? '', array( 'class' => 'form-control' , 'id' => 'discount'))); ?>

                                    </div>
                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                        <?php echo e(formDropdown(__('xcustomer::customer.labels.discount_type'), 'discount_type',getConfig('DISCOUNT_TYPE'),isset($customer->discount_type) ? $customer->discount_type : getConfigValue('DISCOUNT_TYPE'), array('class' => 'form-control', 'id' => 'discount_type'))); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="card" id="payment-details-card">
                        <div class="card-header">
                            <h4>Customer Area</h4>
                        </div>
                        <div class="card-body">
                            <div class="row gutter">
                                
                                    
                                
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php
                                        $roles = \Pramix\XUser\Models\User::role('REPRESENTATIVE')->pluck('username','id');
                                    ?>
                                    <?php echo e(formDropdown('Rep', 'rep',$roles, isset($customer->rep_id) ? $customer->rep_id :'', array('class' => 'form-control select2 validate[required]', 'id' => 'rep'))); ?>

                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="card" id="business_address_panel">
                        <div class="card-header">
                            <h4><?php echo e(__('xcustomer::customer.headings.panel_business_address')); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row gutter">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formText(__('xcustomer::customer.labels.street1'), 'business_street1', $business_address->address_line_1 ?? '', array( 'class' => 'form-control' , 'id' => 'business_street1'))); ?>

                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formText(__('xcustomer::customer.labels.street2'), 'business_street2', $business_address->address_line_2 ?? '', array( 'class' => 'form-control' , 'id' => 'business_street2'))); ?>

                                </div>
                            </div>
                            <div class="row gutter">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formDropdown(__('xcustomer::customer.labels.district'), 'business_district_id',\Pramix\XGeneral\Models\DistrictsModel::pluck('name_en','id'), isset($business_address->district_id) ? $business_address->district_id :'', array('class' => 'form-control select2', 'id' => 'business_district_id'))); ?>

                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formDropdown(__('xcustomer::customer.labels.city'), 'business_city_id',\Pramix\XGeneral\Models\CityModel::pluck('name_en','id'), isset($business_address->city_id) ? $business_address->city_id :'', array('class' => 'form-control select2', 'id' => 'business_city_id'))); ?>

                                </div>
                            </div>
                            <div class="row gutter">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formDropdown(__('xcustomer::customer.labels.country'), 'business_country', $countryList , $business_address->country ?? '' , array('class' => 'form-control select2', 'id' => 'business_country'))); ?>

                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                </div>
                            </div>

                            <?php echo e(formTextArea(__('xcustomer::customer.labels.remarks'), 'business_remarks', $business_address->description ?? '', array( 'class' => 'form-control' , 'id' => 'business_remarks', 'rows' => 3))); ?>


                        </div>
                    </div>

                    <div class="form-group">
                        <div class="checkbox checkbox-inline">
                            <input type="checkbox" id="add_shipping" value="shipping_address"/>
                            <label
                                for="add_shipping"><?php echo e(__('xcustomer::customer.labels.add_shipping_address')); ?></label>
                        </div>
                    </div>
                    <div class="card" id="shipping_address_panel">
                        <div class="card-header">
                            <h4><?php echo e(__('xcustomer::customer.headings.panel_shipping_address')); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row gutter">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formText(__('xcustomer::customer.labels.street1'), 'shipping_street1', $shipping_address->address_line_1 ?? '', array( 'class' => 'form-control' , 'id' => 'shipping_street1'))); ?>

                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formText(__('xcustomer::customer.labels.street2'), 'shipping_street2', $shipping_address->address_line_2 ?? '', array( 'class' => 'form-control' , 'id' => 'shipping_street2'))); ?>

                                </div>
                            </div>
                            <div class="row gutter">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formDropdown(__('xcustomer::customer.labels.district'), 'shipping_district_id',\Pramix\XGeneral\Models\DistrictsModel::pluck('name_en','id'), isset($shipping_address->district_id) ? $shipping_address->district_id :'', array('class' => 'form-control select2', 'id' => 'shipping_district_id'))); ?>

                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formDropdown(__('xcustomer::customer.labels.city'), 'shipping_city_id',\Pramix\XGeneral\Models\CityModel::pluck('name_en','id'), isset($shipping_address->city_id) ? $shipping_address->city_id :'', array('class' => 'form-control select2', 'id' => 'shipping_city_id'))); ?>

                                </div>
                            </div>

                            <div class="row gutter">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                    <?php echo e(formDropdown(__('xcustomer::customer.labels.country'), 'shipping_country', $countryList , $shipping_address->country ?? '' , array('class' => 'form-control select2', 'id' => 'shipping_country'))); ?>

                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                                </div>
                            </div>
                            <?php echo e(formTextArea(__('xcustomer::customer.labels.remarks'), 'shipping_remarks', $shipping_address->description ?? '', array( 'class' => 'form-control' , 'id' => 'shipping_remarks', 'rows' => 3))); ?>

                        </div>
                    </div>

                </div>



                </div>

            </div>
            </form>
            <?php if(Request::ajax()==0): ?>
                <div class="card" id="customer_comment_content">
                    <?php echo $__env->make('xgeneral::comment_section', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('include_js'); ?>
<script src='https://cdnjs.cloudflare.com/ajax/libs/dragula/3.7.2/dragula.min.js'></script>

    <script src="<?php echo e(asset('/pramix/js/customer_js.js')); ?>"></script>
    <script src="<?php echo e(asset('/pramix/js/media_js.js')); ?>"></script>
    <script src="<?php echo e(asset('/plugins/fineuploader/fine-uploader.min.js')); ?>"></script>
[]
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom_script'); ?>
<?php echo $__env->make('xmedia::qq_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        $(document).ready(function () {

            window.onbeforeunload = function() {
                return "Are you sure you want to leave?";
            };

            if ($('#shipping_address_status').val() == 0 || $('#shipping_address_status').val() == '') {
                $('#shipping_address_panel').hide();
            }

            if ($('#add_as_company_name').val() == 'C' || $('#add_as_company_name').val() == '') {
                $('#company_detail_panel').hide();
            }


            $("#customer_mobile").intlTelInput({
                    preferredCountries: ['<?php echo e(config('system.default_country_code')); ?>'],
                    nationalMode: true,
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.1.2/js/utils.js" // just for formatting/placeholders etc
                }
            );
            $("#customer_telephone").intlTelInput({
                    preferredCountries: ['<?php echo e(config('system.default_country_code')); ?>'],
                    nationalMode: true,
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.1.2/js/utils.js" // just for formatting/placeholders etc
                }
            );

            $("#fax").intlTelInput({
                    preferredCountries: ['<?php echo e(config('system.default_country_code')); ?>'],
                    nationalMode: true,
                    utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.1.2/js/utils.js" // just for formatting/placeholders etc
                }
            );
            //My new business address

            $('#business_country , #shipping_country').val('<?php echo e(config('system.default_country')); ?>').trigger('change');

            <?php if(isset($business_address->district_id)): ?>
            $('#business_district_id').val(<?php echo e($business_address->district_id); ?>).trigger('change.select2');
            $('#business_city_id').val(<?php echo e($business_address->city_id); ?>).trigger('change.select2');
                <?php else: ?>
            var selecteddistrict = new Option('Please select district', '', true, true);
            $('#business_district_id').append(selecteddistrict).trigger('change');

            var selectedcity = new Option('Please select city', '', true, true);
            $('#business_city_id').append(selectedcity).trigger('change');
            <?php endif; ?>


            <?php if(isset($business_address->country)): ?>
            $('#business_country').val('<?php echo e($business_address->country); ?>').trigger('change.select2');
            <?php endif; ?>

            //My new shipping

            <?php if(isset($shipping_address->district_id)): ?>
            $('#shipping_district_id').val(<?php echo e($shipping_address->district_id); ?>).trigger('change.select2');
            $('#shipping_city_id').val(<?php echo e($shipping_address->city_id); ?>).trigger('change.select2');
                <?php else: ?>
            var selecteddistrict = new Option('Please select district', '', true, true);
            $('#shipping_district_id').append(selecteddistrict).trigger('change');

            var selectedcity = new Option('Please select city', '', true, true);
            $('#shipping_city_id').append(selectedcity).trigger('change');
            <?php endif; ?>

            <?php if(isset($shipping_address->country)): ?>
            $('#shipping_country').val('<?php echo e($shipping_address->country); ?>').trigger('change.select2');
            <?php endif; ?>


            // var selectarea = new Option('Select customer area', '', true, true);
            // $('#area').append(selectarea).trigger('change');

            var selectedrep = new Option('Select rep', '', true, true);
            $('#rep').append(selectedrep).trigger('change');



         //   $('#area').val("<?php echo e($customer->area_id ?? ''); ?>").trigger('change.select2');
            $('#rep').val("<?php echo e($customer->rep_id ?? ''); ?>").trigger('change.select2');

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make((( Request::ajax()) ? 'layouts.model' : 'layouts.app' ), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xcustomer/src/views/create_customer.blade.php ENDPATH**/ ?>