<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    <?php echo getLogo(); ?>

    <H2>PAYMENT SUMMARY REPORT CUSTOMER WISE</H2>

    <p>Filtered by:</p>
    <p>Payment Method : <?php if($payment_method == null): ?>
            All Payments
        <?php else: ?>
            <?php echo e($payment_method); ?>

        <?php endif; ?>
    </p>
    <p>Supplier : <?php if($customer_details == null): ?>
            All Customers
        <?php else: ?>
            <?php echo e($customer_details->business_name); ?>

        <?php endif; ?>
    </p>
    <p>From Date : <?php echo e($from_date ?? ''); ?> | To Date : <?php echo e($end_date ?? ''); ?></p>
    <p>Rep : <?php echo e($rep ?? ''); ?></p>

    <table style="width: 100%;">
        <tr>
            <th style="width: 14%;">Payment #</th>
            <th style="width: 14%;">Invoice #</th>
            <th style="width: 16%;">Date</th>
            <th style="width: 14%">Ref #</th>
            <th style="width: 14%">Method #</th>
            <th style="width: 20%;">Remarks</th>
            <th style="width: 26%; text-align: right">Amount</th>
        </tr>
    </table>
    <?php
    $full_total_amount = 0;
    ?>
    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <strong>Debator: </strong> <?php echo e($customer->company_name ?? ''); ?> <?php echo e($customer->business_name ?? ''); ?> | <strong>City: </strong>
        <?php echo e($customer->area->name_en ?? ''); ?> <br>
        <hr>
        <table style="width: 100%">
            <?php
                $total_amount = 0;
            ?>
            <?php $__currentLoopData = $customer->invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(auth()->user()->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM'): ?>
                    <?php if($invoice->user_type == '35'): ?>
                        <?php $__currentLoopData = $invoice->invoice_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($payment->status == 1 && $payment->user_type == '35'): ?>
                                <?php
                                 $payment_total= \App\Utils\CommonUtil::calculatePaymentTotal($payment->id);
                                $full_total_amount += $payment_total;
                                $total_amount += $payment_total;
                                ?>
                                <tr>
                                    <td style="width: 14%;"><?php echo e($payment->payment_code); ?></td>
                                    <td style="width: 14%;"><?php echo e($invoice->invoice_code); ?></td>
                                    <td style="width: 12%;"><?php echo e($payment->cheque_date); ?></td>
                                    <td style="width: 14%"><?php echo e($payment->payment_ref_no); ?></td>
                                    <td style="width: 14%"><?php echo e($payment->payment_method); ?></td>
                                    <td style="width: 20%;"><?php echo e($payment->payment_remarks); ?></td>
                                    <td style="width: 26%; text-align: right">
                                        <?php echo e(\App\Http\Helper::formatPrice($payment_total)); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                <?php else: ?>
                    <?php $__currentLoopData = $invoice->invoice_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($payment->status == 1): ?>
                            <?php
                              $payment_total= \App\Utils\CommonUtil::calculatePaymentTotal($payment->id);
                            $full_total_amount += $payment_total;
                            $total_amount += $payment_total;
                            ?>
                            <tr>
                                <td style="width: 14%;"><?php echo e($payment->payment_code); ?></td>
                                <td style="width: 14%;"><?php echo e($invoice->invoice_code); ?></td>
                                <td style="width: 12%;"><?php echo e($payment->cheque_date); ?></td>
                                <td style="width: 14%"><?php echo e($payment->payment_ref_no); ?></td>
                                <td style="width: 14%"><?php echo e($payment->payment_method); ?></td>
                                <td style="width: 20%;"><?php echo e($payment->payment_remarks); ?></td>
                                <td style="width: 26%; text-align: right">
                                    <?php echo e(\App\Http\Helper::formatPrice($payment_total)); ?>

                                </td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <th style="width: 74%;" colspan="6">Total</th>
                <th style="width: 26%; text-align: right"><?php echo e(\App\Http\Helper::formatPrice($total_amount)); ?></th>
            </tr>
        </table>
        <hr class="double_hr">
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <table style="width: 100%;">
        <tr>
            <th style="width: 76%;" colspan="6">Full Total</th>
            <th style="width: 24%; text-align: right"><?php echo e(\App\Http\Helper::formatPrice($full_total_amount)); ?></th>
        </tr>
    </table>
</body>

</html>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xreports/src/views/sales/payment_summary/payment_summary.blade.php ENDPATH**/ ?>