<tr>
    <td><?php echo e($invoice->invoice_code); ?></td>
    <td><?php echo e($invoice->invoice_date); ?></td>
    <td><?php echo e(App\Http\Helper::formatPrice($invoice->total)); ?></td>
    <td><?php echo e(App\Http\Helper::formatPrice($invoice->discount)); ?></td>
    <?php
         $invoice_paid_amount_total = \App\Utils\CommonUtil::calculatePaidAmountInvoice($invoice->id);
         $invoice_balance_total = \App\Utils\CommonUtil::calculateInvoiceOutstanding($invoice->id);
    ?>
    <td><?php echo e(App\Http\Helper::formatPrice($invoice_paid_amount_total)); ?></td>
    <td><?php echo e(App\Http\Helper::formatPrice($invoice_balance_total)); ?></td>
    <td>
        <?php if($invoice->total <= $invoice->paid_amount): ?>
            <span class="text-success"><strong>Completed</strong></span>
        <?php elseif($invoice->total == $invoice->balance): ?>
            <?php
                $count_days = Carbon\Carbon::now()->diff(Carbon\Carbon::parse($invoice->invoice_date));
            ?>
            <span class="text-danger"><strong>Pending</strong></span> <?php echo e($count_days->format('%d Days')); ?>

        <?php elseif($invoice->total != $invoice->balance): ?>
            <span class="text-primary"><strong>Partial</strong></span>
        <?php else: ?>
        <?php endif; ?>
    </td>
    <td>
        <?php if($invoice->customer == null): ?>
            <strong>Quick Sell</strong>
        <?php elseif($invoice->status == 'O'): ?>
            <span class="text-danger"><strong>Order</strong></span>
        <?php elseif($invoice->status == 'D'): ?>
            <span class="text-success"><strong>Ready to Dispatch</strong></span>
        <?php elseif($invoice->status == 'I'): ?>
            <span class="text-primary">Invoice</span>
        <?php else: ?>
        <?php endif; ?>
    </td>
    <td>
        <div class="input-group">
            <input type="hidden" name="invoices[<?php echo e($item_count); ?>][id]" value="<?php echo e($invoice->id); ?>">
            <input type="number" class="form-control" id="discount" name="invoices[<?php echo e($item_count); ?>][discount]"
                value="0.00">
        </div>
    </td>
    <td>
        <a href="javascript:void(0)" class="remove_selected_invoice btn btn-danger btn-xs" data-toggle="tooltip"
            data-placement="right" title="" data-original-title="Delete " aria-describedby="tooltip934027"><i
                class="fa fa-trash-o" aria-hidden="true"></i></a>
    </td>
</tr>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xinvoice/src/views/invoices-table-body.blade.php ENDPATH**/ ?>