<!DOCTYPE html>
<html lang="en">

<head>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css"
        integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous">
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        .double_hr {
            overflow: visible;
            /* For IE */
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }
        p.date{
            position: absolute;
            top: 0;
            right: 0;
        }
    </style>

</head>

<body>

    <div class="main-container">
        <?php
            $currentDate = \Carbon\Carbon::now()->format('Y-m-d');
        ?>
    <p class="date"><?php echo e($currentDate); ?></p>
        <div class="row">
            <div class="col-xs-6">
                <p><?php echo e(getConfigArrayValueByKey('COMPANY_DETAILS', 'company_name')); ?></p>
                <p>CHEQUE RETURN OUTSTANDING REPORT PERIOD WISE</p>
            </div>
        </div>

        <table class="table" style="width: 100%">
            <tr>
                <th>Debtor Name</th>
                <th class="text-right">Total</th>
                <th class="text-right">0 - 30 Days</th>
                <th class="text-right">31 - 60 Days</th>
                <th class="text-right">61 - 90 Days</th>
                <th class="text-right">Over 91 Days</th>
            </tr>
            <?php $__currentLoopData = $returned_cheques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $returned_cheque): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td style="width: 25%"><?php echo e($returned_cheque->customer->company_name); ?> <?php echo e($returned_cheque->customer->business_name); ?> <?php echo e($returned_cheque->customer->mobile); ?></td>
                    <td class="text-right" style="width: 15%">
                        <?php echo e(\App\Http\Helper::formatNumber($returned_cheque['total_cheque_return_amount'])); ?></td>
                    <td class="text-right" style="width: 15%">
                        <?php if($returned_cheque['less_30_days'] <= 0): ?>
                        <?php echo e(\App\Http\Helper::formatNumber(0)); ?></td>
                        <?php else: ?>
                        <?php echo e(\App\Http\Helper::formatNumber($returned_cheque['less_30_days'])); ?></td>
                        <?php endif; ?>
                    <td class="text-right" style="width: 15%">
                        <?php if($returned_cheque['between_31_60_days'] <= 0): ?>
                        <?php echo e(\App\Http\Helper::formatNumber(0)); ?></td>
                        <?php else: ?>
                        <?php echo e(\App\Http\Helper::formatNumber($returned_cheque['between_31_60_days'])); ?></td>
                        <?php endif; ?>
                    <td class="text-right" style="width: 15%">
                        <?php if($returned_cheque['between_61_90_days'] <= 0 ): ?>
                        <?php echo e(\App\Http\Helper::formatNumber(0)); ?></td>
                        <?php else: ?>
                        <?php echo e(\App\Http\Helper::formatNumber($returned_cheque['between_61_90_days'])); ?></td>
                        <?php endif; ?>
                    <td class="text-right" style="width: 15%">
                        <?php if($returned_cheque['over_91'] <= 0 ): ?>
                        <?php echo e(\App\Http\Helper::formatNumber(0)); ?></td>
                        <?php else: ?>
                        <?php echo e(\App\Http\Helper::formatNumber($returned_cheque['over_91'])); ?></td>
                        <?php endif; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>


    </div>

</body>

</html>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xreports/src/views/sales/cheque_return_outstanding_period_wise/cheque_return_outstanding_period_wise_report.blade.php ENDPATH**/ ?>