<?php $__env->startSection('include_css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <!-- Dashboard wrapper starts -->
    <div class="dashboard-wrapper">

        <!-- Top bar starts -->
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4><?php echo e(__('xproduct::product.headings.product_list')); ?></h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ADD_PRODUCTS')): ?>
                        <ul class="right-stats" id="mini-nav-right">
                            <a href="<?php echo e(url('product/create')); ?>" class="btn btn-primary"><i class="fa fa-plus"
                                    aria-hidden="true"></i>
                                <?php echo e(__('xproduct::product.buttons.new_product')); ?></a>
                        </ul>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <!-- Top bar ends -->

        <!-- Main container starts -->
        <div class="main-container">
            <!-- Row starts -->
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="form-inline data_list_filters">
                                <form class="form-inline" action="<?php echo e(route('product.index')); ?>">
                                    <?php
                                        $categories = \Pramix\XProduct\Models\ProductCategoriesModel::where('parent_id', 0)->get();
                                    ?>
                                    <div class="form-group" id="aod_reason_filter_div">
                                    <label for="">Product Category</label> <br>
                                        <select class="form-control select2" name="product_category" id="product_category">
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <optgroup label="<?php echo e($category->category_name); ?>" <?php if(request('product_category') == $category->id): ?> selected <?php endif; ?>>

                                                    <?php $childs = \Pramix\XProduct\Models\ProductCategoriesModel::where('parent_id', $category->id)->get(); ?>
                                                    <?php if(count($childs) > 0): ?>
                                                        <ul class="list-group">
                                                            <?php $__currentLoopData = $childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($child->id ?? ''); ?>" >
                                                                    <?php echo e($child->category_name ?? ''); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="">STOCK ID</label> <br>
                                        <input type="text" name="stock_id" value="<?php echo e(request('stock_id')); ?>" class="form-control" id="searchfullname"
                                               placeholder="STOCK ID">
                                    </div>
                                    <div class="form-group">
                                        <label for="">ITEM NAME</label> <br>
                                        <input type="text" name="item_code" value="<?php echo e(request('item_code')); ?>" class="form-control" id="searchfullname"
                                               placeholder="ITEM NAME">
                                    </div>
                                    <div class="form-group">
                                        <label for="">description</label> <br>
                                        <input type="text" name="description" value="<?php echo e(request('description')); ?>" class="form-control" id="searchfullname"
                                               placeholder="description">
                                    </div>
                                    <div class="form-group">
                                        <br>&nbsp;&nbsp;<button type="submit" style="margin-top: 10px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Submit</button>
                                    </div>
                                    <div class="form-group">
                                        <br>&nbsp;&nbsp; <a href="<?php echo e(route('product.index')); ?>" style="margin-top: 10px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Reset</a>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table id="product_list_table" class="table table-striped table-bordered no-margin" cellspacing="0"
                            width="100%">
                            <thead>
                                <tr>
                                    <th hidden></th>
                                    <th></th>
                                    <th>Stock ID</th>
                                    <th><?php echo e(__('xproduct::product.labels.product_name_code')); ?></th>
                                    <th><?php echo e(__('xproduct::product.labels.description')); ?></th>
                                    <th><?php echo e(__('xproduct::product.labels.category')); ?></th>
                                    <th><?php echo e(__('xproduct::product.labels.quantity_on_hand')); ?></th>
                                    <th><?php echo e(__('xproduct::product.labels.normal_price')); ?></th>
                                    <th><?php echo e(__('xproduct::product.labels.discount')); ?></th>
                                    <th>Action</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php
                                        $edit_product_permission = false;
                                        $delete_product_permission = false;
                                        if (Illuminate\Support\Facades\Auth::user()->can('EDIT_PRODUCTS')) {
                                            $edit_product_permission = true;
                                        }
                                        if (Illuminate\Support\Facades\Auth::user()->can('DELETE_PRODUCTS')) {
                                            $delete_product_permission = true;
                                        }
                                ?>

                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td hidden><?php echo e($product->id); ?></td>
                                        <td>
                                    
                                            <i class="fa fa-product-hunt" aria-hidden="true"></i>
                                        </td>
                                        <td><?php echo e($product->stock_id); ?></td>
                                        <td><?php echo e($product->item_code); ?></td>
                                        <td><?php echo e($product->description); ?></td>
                                        <td><?php echo e($product->category->category_name); ?></td>
                                        <td><?php echo e(Pramix\XInventory\Models\Inventory::getProductStock($product->id)); ?></td>
                                        <td><?php echo e(App\Http\Helper::formatPrice($product->price)); ?></td>
                                        <td>
                                            <?php if($product->discount): ?>
                                                <?php if($product->discount->start_date <= now() && $product->discount->end_date >= now()): ?>
                                                    <?php if($product->discount->discount_type == 'P'): ?>
                                                        <?php echo e($product->discount->amount . '%'); ?>

                                                    <?php else: ?>
                                                        <?php echo e(App\Http\Helper::formatPrice($product->discount->amount)); ?>

                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($edit_product_permission): ?>
                                                <a class="btn btn-info btn-xs" href="<?php echo e(url('/product/' . $product->id . '/edit')); ?>" id="edit_<?php echo e($product->id); ?>" data-original-title="" title=""><i class="fa fa-pencil"></i></a>
                                            <?php endif; ?>

                                            <?php if($delete_product_permission): ?>
                                                &nbsp;<button class="delete_product btn btn-danger btn-xs" data-toggle="tooltip" data-placement="right" title="" data-original-title="Delete " aria-describedby="tooltip934027"><i class="fa fa-trash-o" aria-hidden="true"></i></button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            </tbody>
                        </table>
                        <div class="d-flex justify-content-end">
                            <?php echo e($products->appends($_GET)->links()); ?>

                        </div>
                    </div>


                </div>
            </div>
            <!-- Row ends -->

        </div>
        <!-- Main container ends -->

    </div>
    <!-- Dashboard wrapper ends -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('include_js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {
            // var product_list_table = $('#product_list_table').DataTable({
            //     // dom: 'Blfrtip',
            //     lengthMenu: [
            //         [25, 50, 100, -1],
            //         ['25 ', '50 ', '100', 'All']
            //     ],
            //     // buttons: [
            //     //     {
            //     //         extend: 'copy',
            //     //         exportOptions: {
            //     //             columns: [1, 2, 3, 4, 5, 6, 7, 8, 9]
            //     //         },
            //     //         className: 'btn-primary'
            //     //     },
            //     //     {
            //     //         extend: 'excel',
            //     //         exportOptions: {
            //     //             columns: [1, 2, 3, 4, 5, 6, 7, 8, 9]
            //     //         },
            //     //         className: 'btn-primary'
            //     //     },
            //     //     {
            //     //         extend: 'print',
            //     //         exportOptions: {
            //     //             columns: [1, 2, 3, 4, 5, 6, 7, 8, 9]
            //     //         },
            //     //         className: 'btn-primary test-datatable-btn'
            //     //     },
            //     // ],
            //     processing: true,
            //     serverSide: true,
            //     order: [
            //         [0, "desc"]
            //     ],
            //     'iDisplayLength': 10,
            //     ajax: '<?php echo route('get.all_products'); ?>',
            //     columns: [{
            //             data: 'id',
            //             name: 'id',
            //             'bVisible': false
            //         },
            //         {
            //             data: 'image',
            //             name: 'image'
            //         },
            //         {
            //             data: 'stock_id',
            //             name: 'stock_id'
            //         },
            //         {
            //             data: 'item_code',
            //             name: 'item_code'
            //         },
            //         {
            //             data: 'description',
            //             name: 'description'
            //         },
            //         {
            //             data: 'category_name',
            //             name: 'category_name'
            //         },
            //         {
            //             data: 'qty_on_hand',
            //             name: 'qty_on_hand'
            //         },
            //         {
            //             data: 'price',
            //             name: 'price',
            //             className: 'dt-body-right'
            //         },
            //         {
            //             data: 'discount',
            //             name: 'discount'
            //         },
            //         {
            //             data: 'action',
            //             name: 'action'
            //         },
            //     ]
            // });

            $('#product_category').on('change', function() {
                var data = $('#product_category').select2('data')
                product_list_table.column(5)
                    .search(data[0].text)
                    .draw();
            });

            var selectedcategory = new Option('Select Product Category', '', true, true);
            $('#product_category').append(selectedcategory).trigger('change select2');

            $(document).on('click', '.delete_product', function(e) {
                var data = {};
                var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
                data['id'] = firstTDValue;
                var parent = $(this).parents('tr');

                var delete_confirm = $.confirm({
                    title: "Delete Product",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function() {
                                e.preventDefault();
                                var params = {

                                };

                                $.ajax({
                                    url: BASE + 'product/' + data['id'],
                                    type: 'DELETE',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {
                                            delete_confirm.close();
                                            notification(response);
                                            location.reload();
                                        }
                                    },
                                    error: function(errors) {
                                    }
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function() {}
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xproduct/src/views/products_list.blade.php ENDPATH**/ ?>