<!DOCTYPE html>
<html lang="en">
<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .double_hr {
            overflow: visible;
            /* For IE */
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    <?php echo getLogo(); ?>

    <H2>CUSTOMER TRANSACTION HISTORY REPORT</H2>
    <p>From Date : <?php echo e($from_date ?? ''); ?> | To Date : <?php echo e($end_date ?? ''); ?></p>
    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <strong>Debator: </strong> <?php echo e($customer['company_name'] ?? ''); ?>

    <table style="width: 100%;">
        <tr>
            <th style="width: 12%;">Ref #</th>
            <th style="width: 16%;">Date</th> <!-- Increased width for Date column -->
            <th style="width: 8%;">Description</th> <!-- Reduced width for Description column -->
            <th style="width: 18%;">Remarks</th>
            <th style="width: 16%; text-align: right;">Credit</th>
            <th style="width: 16%; text-align: right;">Debit</th>
            <th style="width: 16%; text-align: right;">Balance</th>
        </tr>
        <?php $__currentLoopData = $customer['invoices']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr style="background-color: white !important; background: white !important">
            <th style="width: 12%; font-weight: normal; background-color: white !important; background: white !important"><?php echo e($item['refNo']); ?></th>
            <th style="width: 12%; font-weight: normal; background-color: white !important; background: white !important"><?php echo e($item['date']); ?></th>
            <th style="width: 10%; font-weight: normal; background-color: white !important; background: white !important"><?php echo e($item['description']); ?></th>
            <th style="width: 18%; font-weight: normal; background-color: white !important; background: white !important"><?php echo e($item['remarks']); ?></th>
            <th style="width: 16%; text-align: right; font-weight: normal; background-color: white !important; background: white !important"><?php echo e($item['credit']); ?></th>
            <th style="width: 16%; text-align: right; font-weight: normal; background-color: white !important; background: white !important"><?php echo e($item['debit']); ?></th>
            <th style="width: 16%; text-align: right; font-weight: normal; background-color: white !important; background: white !important"><?php echo e($item['balance']); ?></th>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>

</html>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xreports/src/views/sales/customer_transaction_history_report/customer_transaction_history.blade.php ENDPATH**/ ?>