<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 10px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    <?php echo getLogo(); ?>

    <H2>Low Stock Products Report</H2>


    <p>Date : <?php echo e(\Carbon\Carbon::now()); ?></p>

    <table>
        <tr>
            <th>Category</th>
            <th>Stock ID</th>
            <th>Item Name/Code</th>
            <th>Qty on hand</th>
        </tr>



        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>

                <td><?php echo e($product->category->category_name); ?></td>
                <td><?php echo e($product->stock_id); ?></td>
                <td><?php echo e($product->item_code); ?></td>
                <td><?php echo e(\Pramix\XInventory\Models\Inventory::getProductStock($product->id)); ?></td>


            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </table>
</body>

</html>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xreports/src/views/inventory/low_stock_products_report/low_stock_products.blade.php ENDPATH**/ ?>