<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    <?php echo getLogo(); ?>


    <H2>SALES SUMMARY REPORT ITEM WISE</H2>
    <p>Filtered by:</p>
    <p>From Date : <?php echo e($from_date ?? ''); ?> | To Date : <?php echo e($end_date ?? ''); ?></p>
    <p>Customer : <?php echo e($customer ?? ''); ?> | Area : <?php echo e($city ?? ''); ?></p>
    <p>Rep : <?php echo e($rep ?? ''); ?> | Item : <?php echo e($item ?? ''); ?></p>
    <table>
        <tr>
            <th>Order #</th>
            <th>Date</th>
            <th>Item</th>
            <th style="text-align: right;">qty</th>
            <th style="text-align: right;">Total</th>
        </tr>
        <?php
        $total_qty = 0;
        $total = 0;
        ?>
        <?php $__currentLoopData = $invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <?php
                 $invoice_item_sub_total = \App\Utils\CommonUtil::InvoiceItemSubTotalSum($invoice_item->id);
                 $invoice_qty_total = \App\Utils\CommonUtil::InvoiceItemQtySum($invoice_item->id);

                    $total_qty += $invoice_qty_total;
                    $total += $invoice_item_sub_total;
                ?>
                <td><?php echo e($invoice_item->invoice->invoice_code); ?></td>
                <td><?php echo e($invoice_item->invoice->invoice_date); ?></td>
                <td><?php echo e($invoice_item->description); ?></td>
                <td style="text-align: right;"><?php echo e(number_format($invoice_qty_total)); ?></td>
                <td style="text-align: right;"><?php echo e(\App\Http\Helper::formatPrice($invoice_item_sub_total)); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <th style="text-align: center;" colspan="3">Total</th>
            <th style="text-align: right;"><?php echo e(number_format($total_qty)); ?></th>
            <th style="text-align: right;"><?php echo e(\App\Http\Helper::formatPrice($total)); ?></th>
        </tr>
    </table>
</body>

</html>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xreports/src/views/sales/sales_report_item_wise/sales_item_wise.blade.php ENDPATH**/ ?>