<?php $__env->startSection('include_css'); ?>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dragula/3.7.2/dragula.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="dashboard-wrapper">
    <div class="top-bar clearfix">
        <div class="row gutter">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="page-title">
                    
                    <h4>Cheque Return Payment Create</h4>
                </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <ul class="right-stats" id="save_button_group">
                </ul>
            </div>
        </div>
    </div>

    <div class="main-container">
        <form action="<?php echo e(url('/') . '/payment'); ?>" method="POST" id="payment_form">
            <?php echo csrf_field(); ?>
            


            <!-- Row starts -->
            <div class="row gutter">
                <div class="col-lg-4 col-md-4 col-sm-6 col-xs-12">
                    <div class="card" id="customer_detail_panel">
                        <div class="card-body">
                            <div class="row gutter">
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">

                                    <label for="">Customer Name</label>
                                    <select name="customer_id_selected" class="form-control select2 select3" id="customer_id_selected">
                                        <option value="">Select Customer Name</option>
                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->company_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                </div>
                                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">

                                    <label for="">Customer Code</label>
                                    <select name="customer_name_selected" class="form-control select2" id="customer_name_selected">
                                        <option value="">Select Customer Code</option>
                                        <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->company_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </select>
                                </div>
                                

                            </div>

                        </div>
                    </div>
                    
                </div>
                <div class="col-lg-8 col-md-8 col-sm-8 col-xs-12">

                    <?php echo $__env->make('cheque_return_payment.cheque_return_payment_filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                </div>
            </div>
            <!-- Row ends -->
            <div class="" id="all_details_panel">
                <div id="overlay"></div>
                

                <div class="card card-primary" id="cheque_return_payment_panel">
                    <div class="card-body">
                        <form id="cheque_return_payment_table_form">
                        <div class="row gutter">
                                <div class="table-responsive">
                                    <table id="cheque_return_payment_table" class="table table-striped table-bordered no-margin"
                                        cellspacing="0" width="100%">
                                        <thead>
                                        <tr>
                                            <th></th>
                                            <th>Cheque Date</th>
                                            <th>Cheque Return Date</th>
                                            <th>CHEQUE No</th>
                                            <th>Amount</th>
                                            <th>Payment Amount</th>
                                            <th>Status</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </form>
                </div>
                </div>


                <div class="form-group">
                </div>

                <!-- Row starts -->
                <div class="row gutter">

                </div>
            </div>
        </form>


    </div>
    <!-- Main container ends -->

</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom_script'); ?>

<script>

    // $(document).on('click', '#cheque_payment_add_item_btn', function(){
    //     alert('in');

    //     $('#chequePaymentForm').submit();
    // })

    $(document).on('click', '#cheque_payment_add_item_btn', function (e) {
        e.preventDefault();


        var table_data = $('#cheque_return_payment_table_form').serialize();

        let payment_date = $('#payment_date').val();
        let cheque_date = $('#cheque_date').val();
        let cheque_bank = $('#cheque_bank').find(":selected").val();
        let customer_id = $('#customer_name_selected').find(":selected").val();
        let payment_ref_no = $('#payment_ref_no').val();
        let payment_remarks = $('#payment_remarks').val();
        let payment_amount = $('#payment_amount').val();
        let payment_code = $('#payment_code').val();
        let payment_method = $('#payment_meth').val();

        let request_body = {
            payment_data: table_data,
            payment_date: payment_date,
            payment_code: payment_code,
            cheque_bank: cheque_bank,
            customer_id:customer_id,
            cheque_date: cheque_date,
            payment_ref_no: payment_ref_no,
            payment_remarks: payment_remarks,
            payment_amount: payment_amount,
            payment_method: payment_method
        }
        // alert(customer_id)


        $.ajax({

            method: 'POST',
            url: "<?php echo e(route('cheque-return-payments.store')); ?>",
            data: request_body,

            success: function (result) {
                if (result.status == 'success') {

                    console.log(result.msg);
                    // $('div.brands_modal').modal('hide');
                    // toastr.success(result.msg);
                    notification(result);
                    window.location.reload();
                } else {
                    notification(result.msg);
                }
            },
        });
    });

    var customer_id = '';


    $(document).on('change', '#customer_id_selected, #customer_name_selected',function(){

        customer_id = $(this).val();
        // console.log(customer_id);


        $.ajax({
        url: BASE + 'cheque-return-payments/cheque-return-details/' + customer_id,
        method: 'GET',
        success: function(response) {

        $('#cheque_return_payment_table tbody').empty();

        $.each(response, function(index, cheque){
            if(cheque.status !== 'paid')
            {

                var row = '<tr>' +
                    '<td><input type="checkbox" class="cheque_payment_check" name="cheque_payment['+ cheque.id +'][cheque_id]" value="' + cheque.id + '"  id="' + cheque.id + '"></td>' +
                    // '<td>'+ cheque.bank_id + '</td>'+
                    '<td style="text-align: right;">'+ cheque.cheque_date + '</td>'+
                    '<td style="text-align: right;">'+ cheque.cheque_return_date + '</td>'+
                    '<td>'+ (cheque.payment_ref_no ? cheque.payment_ref_no : 'N/A')  + '</td>'+
                    '<td style="text-align: right;">'+ 'Rs.' +  cheque.payment_amount + '</td>'+
                    '<td style="text-align: center;"><input type="number" value="" class="cheque_payment_amount" name="cheque_payment['+ cheque.id +'][amount]" id="'+ cheque.id +'" disabled=""></td>'+
                    (cheque.status == 'partial' ? '<td>'+ '<span class="text-primary">' +  '<strong>'+ cheque.status + '</strong>'+ '</span>' + '</td>' : '') +
                    (cheque.status == 'pending' ? '<td>'+ '<span class="text-danger">' + '<strong>'+ cheque.status + '</strong>'+ '</span>' + '</td>' : '') +
                    (cheque.status == 'paid' ? '<td>'+ '<span class="text-success">' + '<strong>'+ cheque.status + '</strong>'+ '</span>' + '</td>' : '') +

                    '</tr>';

                $('#cheque_return_payment_table tbody').append(row);
            }
        });

        },
        error: function(xhr, status, error) {
        // Handle any errors that occur during the AJAX request
        console.log(error);
        }
        });

        returnChequePayments(customer_id);

    })

    function returnChequePayments(customer_id){
        $.ajax({
        url: BASE + 'cheque-return-payments/cheque-return-payment-details/' + customer_id,
        method: 'GET',
        success: function(response) {

        $('#chequeReturnPaymentsTable tbody').empty();

        $.each(response, function(index, cheque_payment){

            var row = '<tr>' +

                '<td>'+ (cheque_payment.payment_code ? cheque_payment.payment_code : 'N/A')+ '</td>'+

                '<td class="text-right">'+ cheque_payment.payment_date + '</td>'+
                '<td class="text-right">'+ cheque_payment.cheque_date + '</td>'+
                '<td >'+ cheque_payment.payment_method + '</td>'+
                // (cheque_payment.status == 'partial' ? '<td>'+ '<span class="text-primary">' +  '<strong>'+ cheque_payment.status + '</strong>'+ '</span>' + '</td>' : '') +
                // (cheque_payment.status == 'pending' ? '<td>'+ '<span class="text-danger">' + '<strong>'+ cheque_payment.status + '</strong>'+ '</span>' + '</td>' : '') +
                // (cheque_payment.status == 'paid' ? '<td>'+ '<span class="text-success">' + '<strong>'+ cheque_payment.status + '</strong>'+ '</span>' + '</td>' : '') +
                // '<td>'+ cheque_payment.bank_id + '</td>'+
                '<td>'+ (cheque_payment.payment_ref_no ? cheque_payment.payment_ref_no : 'N/A')  + '</td>'+
                '<td>'+ (cheque_payment.payment_remarks ? cheque_payment.payment_remarks : 'N/A')  + '</td>'+
                '<td class="text-right">'+ 'Rs.' +  cheque_payment.total_payment_amount.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 }) + '</td>'+
                '</tr>';
                console.log(row);
            $('#chequeReturnPaymentsTable tbody').append(row);
        });

        },
        error: function(xhr, status, error) {
        // Handle any errors that occur during the AJAX request
        console.log(error);
        }
        });

    }

    $(document).on('change', '.cheque_payment_check',function(){
        $('#value_show').prop('hidden', false);
        var payment_amount = $('#payment_amount').val();
        var row = $(this).closest('tr');
        var total = 0 ;
        if(payment_amount == '')
        {
                         $.notify({
                                // options
                                message: "Please enter the amount before proceeding",
                            }, {
                                // settings
                                z_index: 10000000000,
                                type: "danger",
                            });
                    $('.cheque_payment_check').prop('checked', false);
        }
        else {

            if ($(this).prop('checked')) {
                row.find('.cheque_payment_amount').prop('disabled', false);
                var total_string = row.find('td:eq(3)').text();
                displayTotal(total_string)
            } else {

                row.find('.cheque_payment_amount').prop('disabled', true);
                var total_string = row.find('td:eq(3)').text();
                subtractTotal(total_string)
            }

        }
    })

    let display_total  = 0;

    function  displayTotal(total_string){
        let total = total_string.replace(/[^0-9-]+/g,"").slice(0, -2);

        let float_total = parseFloat(total);
        // console.log(total)
        console.log(float_total)
        if(!isNaN(float_total) ){

             display_total +=  float_total;

               $('#cheque_value').prop('hidden', true);
               $('#cheque_value_show').prop('hidden', false);
               let formatted_display_total = display_total.toLocaleString('en-US', { minimumFractionDigits: 2 });
               console.log('inside' + formatted_display_total);
               $('#cheque_value_show').text(formatted_display_total);


    }
}

    function  subtractTotal(total_string){
        let grand_total_string = $('#cheque_value_show').text();
        let total = total_string.replace(/[^0-9-]+/g,"").slice(0, -2);
        let grand_total = grand_total_string.replace(/[^0-9-]+/g,"").slice(0, -2);
        let float_grand_total = parseFloat(grand_total);
        let float_total = parseFloat(total);
        if(!isNaN(float_total) ){

             display_total =  float_grand_total - float_total;

               $('#cheque_value').prop('hidden', true);
               $('#cheque_value_show').prop('hidden', false);
               let formatted_display_total = display_total.toLocaleString('en-US', { minimumFractionDigits: 2 });
               $('#cheque_value_show').text(formatted_display_total);
            }

    }

    $(document).on('input', '.cheque_payment_amount', function(){

        let row = $(this).closest('tr');
        let input_value = parseFloat(row.find('.cheque_payment_amount').val());
        let cheque_payment_amount_string = row.find('td:eq(3)').text();
        let cheque_payment_amount = cheque_payment_amount_string.replace(/[^0-9-]+/g,"").slice(0, -2);
        let main_payment = $('#payment_amount').val();

        if(input_value > main_payment)
        {

            $('.cheque_payment_amount').val('');
        }
        calculate();


    })



    function calculate(){

        let sum = 0;
        let amount = parseFloat($('#payment_amount').val());
        $('.cheque_payment_amount').each(function(){
            let value = parseFloat($(this).val());
            sum += isNaN(value) ? 0 : value;
        })

        // alert(sum)
        let sub_amount = amount - sum;
        if(sub_amount < 0 )
        {
            sub_amount = 0;
        }

        let formatted_sub_amount = sub_amount.toLocaleString('en-US', { minimumFractionDigits: 2 });
        let formatted_sum = sum.toLocaleString('en-US', { minimumFractionDigits: 2 });
        $('#payment_value').text(formatted_sum)
        $('#remaining_value').text(formatted_sub_amount)
        if(sub_amount == 0)
        {
            $('#cheque_payment_add_item_btn').removeClass('disabled');
        }
        if (sub_amount !== 0){
            $('#cheque_payment_add_item_btn').addClass('disabled');
        }

}


     var customer_name_selected = $('#customer_name_selected').select2({
        ajax: {
            url: BASE + 'get_select_two_customer_code_filter',
            dataType: 'json',
            delay: 500,
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.business_name,
                            id: item.id
                        };
                    })
                };
            },
        }
    });


    var customer_id_selected = $('#customer_id_selected').select2({
        ajax: {
            url: BASE + 'get_select_two_customer_name_filter',
            dataType: 'json',
            delay: 500,
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        if (item.company_name != '') {
                            return {
                                text: item.company_name,
                                id: item.id
                            };
                        }
                    })
                };
            },
        }
    });

    //bank input show

    $('#payment_meth').on('change', function(){
        let payment_method = $(this).val();
        if(payment_method == 'cheque')
        {
            $('#cheque_bank').prop('hidden', false)
            $('#payment_col').prop('hidden', false)
        }
        else{
            $('#cheque_bank').prop('hidden', true)
            $('#payment_col').prop('hidden', true)
        }
    })

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make((( Request::ajax()) ? 'layouts.model' : 'layouts.app' ), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/resources/views/cheque_return_payment/create.blade.php ENDPATH**/ ?>