<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 10px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    <?php echo getLogo(); ?>

    <H2>Collection Commission Report</H2>
    <p>Filtered by:</p>
    <p>From Date : <?php echo e($from_date ?? ''); ?> | To Date : <?php echo e($end_date ?? ''); ?></p>
    <p>Rep : <?php echo e($rep ?? ''); ?></p>
    <table>
        <tr>
            <th>Order #</th>
            <th>Date</th>
            <th>Customer</th>
            <th>Receipt</th>
            <th>Payment Date</th>
            <th>Post Day</th>
            <th>Days</th>
            <th style="text-align: right;">Collection</th>
        </tr>
        <?php
        $total = 0;
        ?>
        <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($invoice->collection != 0): ?>
                <tr>
                    <?php
                        $total += $invoice->collection;
                    ?>
                    <td><?php echo e($invoice->invoice_code); ?></td>
                    <td><?php echo e($invoice->invoice_date); ?></td>
                    <td><?php echo e($invoice->company_name . '-' . $invoice->name_en); ?></td>
                    <td><?php echo e($invoice->payment_code); ?></td>
                    <td><?php echo e($invoice->payment_date); ?></td>
                    <td><?php echo e($invoice->cheque_date); ?></td>
                    <td><?php echo e($invoice->days); ?></td>
                    <td style="text-align: right;"><?php echo e(\App\Http\Helper::formatPrice($invoice->collection)); ?></td>
                </tr>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <th style="text-align: center;" colspan="7">Total</th>
            <th style="text-align: right;"><?php echo e(\App\Http\Helper::formatPrice($total)); ?></th>
        </tr>
    </table>
</body>

</html>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xreports/src/views/commission/collection_commission.blade.php ENDPATH**/ ?>