<?php $__env->startSection('content'); ?>
    <input type="hidden" name="page" id="page" value="<?php echo e($page ?? ''); ?>">
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>Cheques List</h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">

                </div>
            </div>
        </div>
        <div class="main-container">
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo e(route('cheque_payment.view')); ?>">

                                <div class="form-inline data_list_filters">
                                    <div class="form-group">
                                        <label for="">Pay Customer</label> <br>

                                            <input type="text" name="customer_name" class="form-control" id="searchcustomername"
                                            placeholder="PAY CUSTOMER" value="<?php echo e(request('customer_name')); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label for="">Cheque return Ref no</label> <br>

                                            <input type="text" name="cheque_return_ref_no" class="form-control" id="searchcustomername"
                                            placeholder="PAY CUSTOMER" value="<?php echo e(request('cheque_return_ref_no')); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label for="">Invoice Number</label> <br>
                                        <input type="text" class="form-control" name="invoice_no"
                                        value="<?php echo e(request('invoice_no')); ?>" placeholder="<?php echo e(__('xpayment::payment.labels.payment_customer')); ?>">
                                    </div>
                                    <div class="form-group">
                                        <div class="col-sm-12">
                                            <br><label for="">Received Date</label><br>
                                            <input name="received_date" value="<?php echo e(request('received_date')); ?>" style="margin-bottom: 20px;" class="form-control dates">

                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="col-sm-12">
                                            <br><label for="">Cheque Date</label><br>
                                            <input name="cheque_date" value="<?php echo e(request('cheque_date')); ?>" style="margin-bottom: 20px;" class="form-control dates">

                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <br>
                                        <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                            <label class="btn btn-primary active">
                                                <input type="radio" name="payment_status" > All
                                            </label>
                                            <label class="btn btn-primary" id="all_status" data-toggle="tooltip"
                                                data-placement="top" title="Status">
                                                <input type="radio" name="payment_status" value="Pending" <?php if(request('payment_status') == 'Pending'): ?> checked <?php endif; ?>> Pending
                                            </label>
                                            <label class="btn btn-primary" id="all_status" data-toggle="tooltip"
                                                data-placement="top" title="Status">
                                                <input type="radio" name="payment_status" value="Cleared" <?php if(request('payment_status') == 'Cleared'): ?> checked <?php endif; ?>> Cleared
                                            </label>
                                            <label class="btn btn-primary ">
                                                <input type="radio" name="payment_status" value="Reject" <?php if(request('payment_status') == 'Reject'): ?> checked <?php endif; ?>> Rejected
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        &nbsp;&nbsp;<button type="submit" style="margin-top: 35px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Submit</button>
                                    </div>
                                    <div class="form-group">
                                        &nbsp;&nbsp; <a href="<?php echo e(route('cheque_payment.view')); ?>" style="margin-top: 35px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Reset</a>
                                    </div>
                                </div>
                            </form>

                        </div>

                    </div>
                    <div class="table-responsive">
                        <table id="payment_list_table" class="table table-striped table-bordered no-margin" cellspacing="0"
                            width="100%">
                            <thead>
                                <tr>
                                    <th hidden></th>
                                    <th>Customer</th>
                                    <th>Cheque NO</th>
                                    <th>Received Date</th>
                                    <th>Cheque Date</th>
                                    <th>Cheque Return Ref Number</th>
                                    <th>Cheque Return Date</th>
                                    <th><?php echo e(__('xpayment::payment.labels.payment_amount')); ?></th>
                                    <th><?php echo e(__('xpayment::payment.labels.payment_status')); ?></th>
                                    <th><?php echo e(__('common.labels.action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $cheques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cheque): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr>

                                    <td hidden><?php echo e($cheque->id); ?></td>
                                    <td><?php echo e($cheque->customer->company_name); ?></td>
                                    <td><?php echo e($cheque->payment_ref_no); ?></td>
                                    
                                    <td><?php echo e($cheque->payment_date); ?></td>
                                    <td><?php echo e($cheque->cheque_date); ?></td>
                                    <td><?php echo e($cheque->cheque_rtn_ref_no ?? 'N/A'); ?></td>
                                    <td><?php echo e($cheque->cheque_return_date); ?></td>
                                    <td><?php echo e(App\Http\Helper::formatPrice($cheque->payment_amount)); ?></td>
                                    <td>
                                        <?php if($cheque->status == 0): ?>
                                            <span class="text-default"><strong>Pending</strong></span>
                                        <?php elseif($cheque->status == 2): ?>
                                            <span class="text-danger"><strong>Reject</strong></span>
                                        <?php else: ?>
                                            <span class="text-success"><strong>Cleared</strong></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php
                                            $approve_or_reject_cheque_payment_permission = false;
                                            if (Auth::user()->can('MANAGE_CHEQUE_PAYMENT')) {
                                                $approve_or_reject_cheque_payment_permission = true;
                                            }
                                        ?>
                                        <?php if($approve_or_reject_cheque_payment_permission): ?>
                                            <?php if($cheque->status == 0): ?>
                                                <button class="btn btn-success btn-sm payment-approve-button fa fa-check" aria-hidden="true"></button>
                                                <button class="btn btn-danger btn-sm payment-delete-button fas fa-times" aria-hidden="true"></button>
                                            <?php elseif($cheque->status == 1): ?>
                                                <button class="btn btn-danger btn-sm payment-delete-button fas fa-times" aria-hidden="true"></button>
                                            <?php endif; ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <div class="d-flex justify-content-end">
                            <?php echo e($cheques->appends($_GET)->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {
            // window.onbeforeunload = function() {
            //     return "Are you sure you want to leave?";
            // };
            $('#all_status').tooltip('show');


            $('#payment_list_table tbody').on('click', 'button.payment-print-button', function(e) {
                var $btn = $(this);
                $btn.button('loading');
                var data = payment_list_table.row($(this).parents('tr')).data();
                var params = {
                    invoice_id: data['invoice_id'],
                    record_payment_id: data['id']
                };
                $.ajax({
                    url: BASE + 'invoice/print_payment',
                    type: 'POST',
                    dataType: 'JSON',
                    data: $.param(params),
                    success: function(response) {
                        if (response.status == 'success') {
                            window.open(response.url);
                            $btn.button('reset');

                        } else {
                            notification(response);
                            $btn.button('reset');
                            return false;
                        }
                    },
                    error: function(xhr, ajaxOptions, thrownError) {
                        notificationError(xhr, ajaxOptions, thrownError);
                    }
                });
                return false;
            });
            $('#payment_list_table tbody').on('click', 'button.payment-edit-button', function(e) {
                var data = payment_list_table.row($(this).parents('tr')).data();
                window.payment_model = $.confirm({
                    title: '',
                    draggable: true,
                    boxWidth: '80%',
                    closeIcon: true,
                    useBootstrap: false,
                    buttons: {
                        close: function() {}
                    },
                    content: 'url:' + BASE + 'payment/view/' + data['id'],
                    onContentReady: function() {
                    },
                    columnClass: 'medium',
                });
                return false;
            })
            $('#payment_list_table tbody').on('click', 'button.payment-delete-button', function(e) {
                var data = {};
                var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
                data['id'] = firstTDValue;
                $.confirm({
                    title: 'Cheque Reject!',
                    content: 'Are you sure?!',
                    buttons: {
                        cancel: function() {},
                        delete: {
                            text: 'Reject',
                            btnClass: 'btn-danger',
                            keys: ['enter', 'shift'],
                            action: function() {
                                var payment_details = $('#payment_list_table :input')
                                    .serialize();
                                var params = {
                                    cheque_id: data['id']
                                };
                                $.ajax({
                                    url: BASE + 'payment/reject_payment',
                                    type: 'POST',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'success') {
                                            // payment_list_table.ajax.reload();
                                            location.reload();
                                        } else {
                                            notification(response);
                                            return false;
                                        }
                                    },
                                    error: function(xhr, ajaxOptions, thrownError) {
                                        notificationError(xhr, ajaxOptions,
                                            thrownError);
                                    }
                                });
                            }
                        }
                    }
                });
            });
            $('#payment_list_table tbody').on('click', 'button.payment-approve-button', function(e) {
                var data = payment_list_table.row($(this).parents('tr')).data();
                $.confirm({
                    title: 'Cheque Approve!',
                    content: 'Are you sure?',
                    buttons: {
                        cancel: function() {
                        },
                        approve: {
                            text: 'Approve',
                            btnClass: 'btn-success',
                            keys: ['enter', 'shift'],
                            action: function() {


                                var params = {
                                    cheque_id: data['id']
                                };
                                $.ajax({
                                    url: BASE + 'payment/approve_payment',
                                    type: 'POST',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'success') {
                                            payment_list_table.ajax.reload();
                                        } else {
                                            notification(response);
                                            return false;
                                        }
                                    },
                                    error: function(xhr, ajaxOptions, thrownError) {
                                        notificationError(xhr, ajaxOptions,
                                            thrownError);
                                    }
                                });
                            }
                        }
                    }
                });
            });
            function updateAllCheques() {
                $.ajax({
                    method: 'POST',
                    url: "<?php echo e(route('payments.update_all_cheques')); ?>",
                    success: function(response) {
                        payment_list_table.ajax.reload();
                    }
                });
            }
            updateAllCheques();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xpayments/src/views/cheque_payments_list.blade.php ENDPATH**/ ?>