<?php $__env->startSection('content'); ?>
    <div class="dashboard-wrapper">

        <!-- Top bar starts -->
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>Product Bulk Price Edit</h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">

                </div>
            </div>
        </div>
        <!-- Top bar ends -->
        <div class="main-container">
            <!-- Main content -->
            <div class="row gutter">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Product Price Edit</h4>
                        </div><!--end card-header-->
                        <div class="card-body">
                            <div class="table-responsive-sm">
                                <form action="<?php echo e(route('bulk-update')); ?>" method="post">
                                <table class="table table-sm mb-0" id="price_update_table">
                                    <thead>
                                    <tr>
                                        <th >Stock ID</th>
                                        <th >Item Code</th>
                                        <th >Description</th>
                                        <th>Current Price</th>
                                        <th >New Price</th>
                                    </tr>
                                    </thead>

                                        <?php echo csrf_field(); ?>
                                    <tbody>


                                    </tbody>

                                    <tr>
                                        <td colspan="4"></td>
                                        <td>
                                            <button class="btn btn-primary">UPDATE</button>
                                        </td>
                                    </tr>

                                </table><!--end /table-->
                            </form>
                            </div><!--end /tableresponsive-->
                        </div><!--end card-body-->
                    </div>
                </div>
            </div>
        </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom_script'); ?>
    <script>
        $(document).ready(function() {

            var product_list_table = $('#price_update_table').DataTable({


                lengthMenu: [
                    [ -1],
                    [ 'All']
                ],

                processing: true,
                serverSide: true,
                order: [
                    [0, "desc"]
                ],
                'iDisplayLength': -1,
                ajax: '<?php echo route('bulk'); ?>',
                columns: [

                    {
                        data: 'stock_id',
                        name: 'stock_id'

                    },
                    {
                        data: 'item_code',
                        name: 'item_code'
                    },
                    {
                        data: 'description',
                        name: 'description',
                        searchable: false
                    },

                    {
                        data: 'price',
                        name: 'price',
                        searchable: false

                    },
                    {
                        data: 'current_price',
                        name: 'current_price',
                        searchable: false
                    },

                ]
            });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/resources/views/bulk-price/index.blade.php ENDPATH**/ ?>