<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 10px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    <?php echo getLogo(); ?>

    <H2>INVENTORY MOVEMENT SUMMARY REPORT</H2>

    <p>Filtered by:</p>
    <p>Product : <?php if($product_details == null): ?>
            All Products
        <?php else: ?>
            <?php echo e($product_details->item_code); ?>

        <?php endif; ?>
    </p>
    <p>Product Category : <?php if($category_details == null): ?>
            All Categories
        <?php else: ?>
            <?php echo e($category_details->category_name); ?>

        <?php endif; ?>
    </p>
    <p>From Date : <?php echo e($from_date ?? ''); ?></p>
    <p>To Date : <?php echo e($end_date ?? ''); ?></p>

    <table>
        <tr>

            <th>Product</th>
            <th>Date</th>

            <th>Qty Change</th>
            <th>Before Qty</th>
            <th>After Qty</th>
            
            <th>Note</th>
            <th>Customer</th>
        </tr>


        <?php $id = 1; ?>

        <?php $__currentLoopData = $inventory_records; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inventory_record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>

                <td><?php echo e($inventory_record->product->item_code); ?></td>
                <td><?php echo e($inventory_record->created_at); ?></td>

                <td>
                    <?php if($inventory_record->type == 'I'): ?>
                        +<?php echo e($inventory_record->qty); ?>

                    <?php else: ?>
                        -<?php echo e($inventory_record->qty); ?>

                    <?php endif; ?>
                </td>
                <td><?php echo e($inventory_record->qty_before); ?></td>
                <td><?php echo e($inventory_record->qty_after); ?></td>
                
                <td>
                    <?php echo e(ucwords(str_replace('_', ' ', getConfigArrayKeyByValue('STOCK_TRANSACTION_TYPES', $inventory_record->transaction_type_id)))); ?>


                </td>
                <td>

                    <?php if(getConfigArrayValueByKey('STOCK_TRANSACTION_TYPES', 'sales_order') == $inventory_record->transaction_type_id): ?>
                        <?php$invoice = \Pramix\XInvoice\Models\InvoiceModel::with('customer')
                                ->where('invoice_code', $inventory_record->order_number)
                                ->first();

                        ?>
                        <?php echo e($invoice->customer->company_name ?? ''); ?>

                    <?php endif; ?>

                </td>
                
            </tr>

            <?php $id++; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    </table>
</body>

</html>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xreports/src/views/inventory/inventory_movement_summary/inventory_movement_summary.blade.php ENDPATH**/ ?>