<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .double_hr {
            overflow: visible;
            /* For IE */
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
        p.date{
            position: absolute;
            top: 0;
            right: 0;
        }
    </style>

</head>

<body>
<?php echo getLogo(); ?>

    
<H2>SALES SUMMARY REPORT INVOICE WISE</H2>
<p>Filtered by:</p>
<p>From Date : <?php echo e($from_date ?? ''); ?> | To Date : <?php echo e($end_date ?? ''); ?></p>
<p>Rep : <?php echo e($rep ?? ''); ?></p>
<table>
    <tr>

        <th style="width: 33%; " >Order #</th>
        <th style="width: 33%; ">Date</th>
        <th style="width: 33%; text-align: right;" >Total</th>
        
        
        
        
    </tr>
</table>
<?php
    $full_total = 0;
    $full_returned = 0;
    // $full_paid = 0;
    $full_balance = 0;
?>
<table>
    <?php
        $total_invoice_amount = 0;
        $total_returned_amount = 0;
        // $total_paid_amount = 0;
        $total_balance = 0;
    ?>
    <?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $full_total += $invoice->total;
            $full_returned += \App\Utils\CommonUtil::calculateTotalReturnAmountInvoice($invoice->id);
            $full_balance += $invoice->total - $full_returned;

            $total_invoice_amount += $invoice->total;
            $total_returned_amount += \App\Utils\CommonUtil::calculateTotalReturnAmountInvoice($invoice->id);;
            $total_balance += $invoice->total - $total_returned_amount;

            $outstanding = \App\Utils\CommonUtil::calculateInvoiceOutstanding($invoice->id);

        ?>
        <?php if($outstanding > 0 || $outstanding < 0): ?>
            <tr>

                <td style="width: 25%;"><?php echo e($invoice->invoice_code); ?></td>
                <td style="width: 25%;">
                    <?php
                        $count_days = \Carbon\Carbon::parse($invoice->invoice_date)->diffInDays(\Carbon\Carbon::now(), false);
                    ?>
                    <?php echo e($invoice->invoice_date); ?>

                </td>
                <td style="width: 25%; text-align: right;">
                    <?php echo e(\App\Http\Helper::formatPrice($invoice->total)); ?>

                </td>
                
            </tr>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <tr>
        <th style="width: 24%;" colspan="2">Total</th>
        <th style="width: 19%; text-align: right;">
            <?php echo e(\App\Http\Helper::formatPrice($total_invoice_amount)); ?>

        </th>
        
        
        
        
    </tr>
</table>
<hr class="double_hr">
<table>
    <tr>
        <th style="width: 67%;">Full Total</th>
        <th style="width: 33%; text-align: right;"><?php echo e(\App\Http\Helper::formatPrice($full_total)); ?>

        </th>
        
        
        

    </tr>
</table>
</body>

</html>
<?php /**PATH /home/cleavr/cmk.clickyapp.cloud/releases/20231228063521705/packages/pramix/xreports/src/views/sales/direct_sale_report/direct_sale_report.blade.php ENDPATH**/ ?>