
@extends('layouts.app')

@section('content')
<div class="dashboard-wrapper">
    <div class="top-bar clearfix">
        <div class="row gutter">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="page-title">
                    <h4>Show Cheque Return Payment</h4>
                </div>
            </div>
        </div>
    </div>
    <div class="main-container">

<div class="row gutter">
    <div class="col-md-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Customer Information</h5>
           <p class="card-text">Name: {{$cheque->customer->company_name}}</p>
          <p class="card-text">Code: {{$cheque->customer->business_name}}</p>

        </div>
      </div>
    </div>


    <div class="card mt-3">
        <div class="card-body">
          <h5 class="card-title">Cheque Return Payment Details</h5>
          <table class="table">
            <thead>
              <tr>
                <th class="text-center">Payment Code</th>
                <th class="text-center">Payment Ref #</th>
                <th class="text-right">Payment Date</th>
                <th class="text-right">Cheque Date</th>
                <th class="text-right">Amount</th>
                <th class="text-center">Cheque Bank</th>
                <th class="text-center">Payment Method</th>
                <th class="text-center">Remarks</th>
                <th class="text-center">Created By</th>

              </tr>
            </thead>
            <tbody>
              <tr>
                <td class="text-center">{{$cheque_return_payment->payment_code ? $cheque_return_payment->payment_code: 'N/A'}}</td>
                <td class="text-center">{{$cheque_return_payment->payment_ref_no}}</td>
                <td class="text-right">{{$cheque_return_payment->payment_date}}</td>
                <td class="text-right">{{$cheque_return_payment->cheque_date}}</td>
                <td class="text-right">RS.{{number_format($cheque_return_payment->total_payment_amount,2)}}</td>
                <td class="text-center">{{$cheque_return_payment->bank_id ? getConfigArrayValueByKey('BANKS_LIST', $cheque_return_payment->bank_id) : 'N/A'}}</td>
                <td class="text-center">{{$cheque_return_payment->payment_method}}</td>
                <td class="text-center">{{$cheque_return_payment->remarks ? $cheque_return_payment->remarks : 'N/A'}}</td>
                <td class="text-center">{{$created_user->username}}</td>
              </tr>

              <!-- Add more rows for additional returned products -->
            </tbody>
          </table>
        </div>
      </div>
    <div class="card mt-3">
        <div class="card-body">
          <h5 class="card-title">Cheque Return Payment Details</h5>
          <table class="table">
            <thead>
              <tr>
                <th class="text-center">Payment Date</th>
                <th class="text-center">Payment Amount</th>
              </tr>
            </thead>
            <tbody>
                @foreach ($returned_cheque_payments as $returned_cheque_payment)
                <tr>
                    <td class="text-center"> {{\Carbon\Carbon::parse($returned_cheque_payment->created_at)->format('Y-m-d') }}</td>
                    <td class="text-center"> RS.{{number_format($returned_cheque_payment->payment_amount, 2) }}</td>
                </tr>
                @endforeach
              <!-- Add more rows for additional returned products -->
            </tbody>
          </table>
        </div>
      </div>

  </div>
    </div>
</div>
@endsection

