@extends('layouts.app')
@section('content')
    <div class="dashboard-wrapper">
        <div class="main-container">
            <!-- Main content -->
            <div class="row gutter">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title"></h4>
                        </div>
                        <!--end card-header-->
                        <div class="card-body">
                            @can('CREATE_DB_BACKUP')
                                <a href="{{ route('backup.create') }}"
                                    class="btn btn-gradient-primary waves-effect waves-light float-right mb-3"><i
                                        class="mdi mdi-plus"></i> Create
                                    DB Backup
                                </a>
                            @endcan
                            <h4 class="header-title mt-0 mb-3">Administrator Backup</h4>
                            <div class="table-responsive-sm">
                                <table class="table table-sm mb-0">
                                    <thead>
                                        <tr>
                                            <th scope="col">File</th>
                                            <th scope="col">Size</th>
                                            <th scope="col">Date</th>
                                            <th scope="col">Age</th>
                                            <th scope="col">Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($backups as $backup)
                                            <tr>
                                                <td>{{ $backup['file_name'] }}</td>
                                                <td>{{ \App\Http\Helper::humanFilesize($backup['file_size']) }}</td>
                                                <td>
                                                    {{ \Carbon\Carbon::createFromTimestamp($backup['last_modified'])->toDateTimeString() }}
                                                </td>
                                                <td>
                                                    {{ \Carbon\Carbon::createFromTimestamp($backup['last_modified'])->diffForHumans(now()) }}
                                                </td>
                                                <td>
                                                    @can('DOWNLOAD_DB_BACKUP')
                                                        <a class="btn btn-xs btn-success"
                                                            href="{{ route('backup.download', $backup['file_name']) }}"><i
                                                                class="fa fa-cloud-download"></i> Download</a>
                                                    @endcan
                                                    @can('DELETE_DB_BACKUP')
                                                        <a class="btn btn-xs btn-danger link_confirmation"
                                                            data-button-type="delete"
                                                            href="{{ route('backup.delete', $backup['file_name']) }}"><i
                                                                class="fa fa-trash-o"></i>
                                                            Delete</a>
                                                    @endcan
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="5" style="text-align: center">
                                                    There are no backups
                                                </td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                <!--end /table-->
                            </div>
                            <!--end /tableresponsive-->
                        </div>
                        <!--end card-body-->
                    </div>
                </div>
            </div>
        </div>
    @endsection
