<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>PAYMENT SUMMARY REPORT CUSTOMER WISE</H2>

    <p>Filtered by:</p>
    <p>Payment Method : @if ($payment_method == null)
            All Payments
        @else
            {{ $payment_method }}
        @endif
    </p>
    <p>Supplier : @if ($customer_details == null)
            All Customers
        @else
            {{ $customer_details->business_name }}
        @endif
    </p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Rep : {{ $rep ?? '' }}</p>

    <table style="width: 100%;">
        <tr>
            <th style="width: 14%;">Payment #</th>
            <th style="width: 14%;">Invoice #</th>
            <th style="width: 16%;">Date</th>
            <th style="width: 14%">Ref #</th>
            <th style="width: 14%">Method #</th>
            <th style="width: 20%;">Remarks</th>
            <th style="width: 26%; text-align: right">Amount</th>
        </tr>
    </table>
    <?php
    $full_total_amount = 0;
    ?>
    @foreach ($customers as $customer)
        <strong>Debator: </strong> {{ $customer->company_name ?? '' }} {{ $customer->business_name ?? '' }} | <strong>City: </strong>
        {{ $customer->area->name_en ?? '' }} <br>
        <hr>
        <table style="width: 100%">
            @php
                $total_amount = 0;
            @endphp
            @foreach ($customer->invoices as $invoice)
                @if (auth()->user()->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM')
                    @if ($invoice->user_type == '35')
                        @foreach ($invoice->invoice_payments as $payment)
                            @if ($payment->status == 1 && $payment->user_type == '35')
                                <?php
                                 $payment_total= \App\Utils\CommonUtil::calculatePaymentTotal($payment->id);
                                $full_total_amount += $payment_total;
                                $total_amount += $payment_total;
                                ?>
                                <tr>
                                    <td style="width: 14%;">{{ $payment->payment_code }}</td>
                                    <td style="width: 14%;">{{ $invoice->invoice_code }}</td>
                                    <td style="width: 12%;">{{ $payment->cheque_date }}</td>
                                    <td style="width: 14%">{{ $payment->payment_ref_no }}</td>
                                    <td style="width: 14%">{{ $payment->payment_method }}</td>
                                    <td style="width: 20%;">{{ $payment->payment_remarks }}</td>
                                    <td style="width: 26%; text-align: right">
                                        {{ \App\Http\Helper::formatPrice($payment_total) }}
                                    </td>
                                </tr>
                            @endif
                        @endforeach
                    @endif
                @else
                    @foreach ($invoice->invoice_payments as $payment)
                        @if ($payment->status == 1)
                            <?php
                              $payment_total= \App\Utils\CommonUtil::calculatePaymentTotal($payment->id);
                            $full_total_amount += $payment_total;
                            $total_amount += $payment_total;
                            ?>
                            <tr>
                                <td style="width: 14%;">{{ $payment->payment_code }}</td>
                                <td style="width: 14%;">{{ $invoice->invoice_code }}</td>
                                <td style="width: 12%;">{{ $payment->cheque_date }}</td>
                                <td style="width: 14%">{{ $payment->payment_ref_no }}</td>
                                <td style="width: 14%">{{ $payment->payment_method }}</td>
                                <td style="width: 20%;">{{ $payment->payment_remarks }}</td>
                                <td style="width: 26%; text-align: right">
                                    {{ \App\Http\Helper::formatPrice($payment_total) }}
                                </td>
                            </tr>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <tr>
                <th style="width: 74%;" colspan="6">Total</th>
                <th style="width: 26%; text-align: right">{{ \App\Http\Helper::formatPrice($total_amount) }}</th>
            </tr>
        </table>
        <hr class="double_hr">
    @endforeach
    <table style="width: 100%;">
        <tr>
            <th style="width: 76%;" colspan="6">Full Total</th>
            <th style="width: 24%; text-align: right">{{ \App\Http\Helper::formatPrice($full_total_amount) }}</th>
        </tr>
    </table>
</body>

</html>
