<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
            border: 1px solid #ddd;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>GOODS RETURN WISE SUMMARY REPORT</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Rep : {{ $rep ?? '' }}</p>
    <table>
        <tr>
            <th style="width:10%;">#</th>
            <th style="width:20%;">Invoice Return Code</th>
            <th style="width:60%;">Item Description</th>
            <th style="width:10%; text-align: right;">QTY</th>
        </tr>
        <?php
        $total = 0;
        ?>
        @foreach ($invoice_returns as $invoice_return)
            <tr>
                @php

                    $total += $invoice_return->total_qty;

                @endphp
                <td style="width:10%;">{{ $loop->iteration }}</td>
                <td style="width:20%;">{{ $invoice_return->invoice_return_code }}</td>
                <td style="width:60%;">{{$invoice_return->description}}</td>
                <td style="width:10%; text-align: right;">{{$invoice_return->total_qty}}</td>

            </tr>
        @endforeach
        <tr>
            <th style="text-align: center;" colspan="3">Total</th>
            <th style="text-align: right;">{{ $total }}</th>
        </tr>
    </table>
</body>

</html>
