<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>Daily Payment Summary Report</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Rep : {{ $rep ?? '' }}</p>
    <table>
        <tr>
            <th>#</th>
            <th>Date</th>
            <th style="text-align: right;">Total</th>
        </tr>
        <?php
        $total = 0;
        ?>
        @foreach ($payments as $payment)
            <tr>
                @php
                //  $payment_total= \App\Utils\CommonUtil::calculatePaymentTotal($payment->id);
                    $total += $payment['payment_amount'];
                @endphp
                <td>{{ $loop->iteration }}</td>
                <td>{{ $payment['payment_date'] }}</td>
                <td style="text-align: right;">{{ \App\Http\Helper::formatPrice($payment['payment_amount']) }}</td>
            </tr>
        @endforeach
        <tr>
            <th style="text-align: center;" colspan="2">Total</th>
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($total) }}</th>
        </tr>
    </table>
</body>

</html>
