<!DOCTYPE html>
<html lang="en">

<head>

    {{-- <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css"
          integrity="sha384-BVYiiSIFeK1dGmJRAkycuHAHRg32OmUcww7on3RYdg4Va+PmSTsz/K68vbdEjh4u" crossorigin="anonymous"> --}}
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        .double_hr {
            overflow: visible;
            /* For IE */
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }

        p.date {
            position: absolute;
            top: 0;
            right: 0;
        }
    </style>

</head>

<body>

    <div class="main-container">
        @php
            $currentDate = \Carbon\Carbon::now()->format('Y-m-d');
        @endphp
        <p class="date">{{ $currentDate }}</p>

        <div class="row">
            <div class="col-xs-6">
                <p>{{ getConfigArrayValueByKey('COMPANY_DETAILS', 'company_name') }}</p>
                <p>OUTSTANDING REPORT</p>
            </div>
        </div>
        <table style="width: 100%">
            <tr>
                <th style="width: 12%">Invoice #</th>
                <th style="width: 12%">Date</th>
                <th style="width: 10%">Description</th>
                <th style="width: 14%; text-align: right;">Debit</th>
                <th style="width: 14%; text-align: right;">Credit</th>
                <th style="width: 14%; text-align: right;">Return</th>
                <th style="width: 14%; text-align: right;">Discount</th>
                <th style="width: 14%; text-align: right;">Balance</th>
                <th style="width: 14%; text-align: right;">No of Days</th>
            </tr>
        </table>
        @foreach ($customers as $customer)
            <strong>Debator :</strong> {{ $customer['customer']->company_name ?? '' }}
            {{ $customer['customer']->business_name ?? '' }} | <strong>Rep
                :</strong> {{ $repName }} <br>
            <hr>
            @php
                $total_invoice_amount = 0;
                $total__paid_amount = 0;
                $total__return_amount = 0;
                $total_balance_total = 0;
                $total_discount_amount = 0;

            @endphp
            <table style="width: 100%">
                @foreach ($customer['invoices'] as $invoice)
                    <tr>
                        <td style="width: 12%">{{ $invoice['invoiceCode'] }}</td>
                        <td style="width: 12%">{{ $invoice['date'] }}</td>
                        <td style="width: 20%; text-align: center;">{{ $invoice['remarks'] }}</td>
                        <td style="width: 14%; text-align: right;">{{ $invoice['total'] }}</td>
                        <td style="width: 14%; text-align: right;">{{ $invoice['totalPaid'] }}</td>
                        <td style="width: 14%; text-align: right;">{{ $invoice['totalReturns'] }}</td>
                        <td style="width: 14%; text-align: right;">{{ $invoice['totalDiscounts'] }}</td>
                        <td style="width: 14%; text-align: right;">{{ $invoice['outstanding'] }}</td>
                        <td style="width: 12%; text-align: center;">{{ $invoice['daysCount'] }}</td>
                    </tr>
                @endforeach
                <tr>
                <th style="width: 12%">Total</th>
                <th style="width: 12%"></th>
                <th style="width: 20%"></th>
                <th style="width: 14%; text-align: right;">{{ $customer['totals']['invoiceTotal'] }}</th>
                <th style="width: 14%; text-align: right;">{{ $customer['totals']['paidTotal'] }}</th>
                <th style="width: 14%; text-align: right;">{{ $customer['totals']['returnTotal'] }}</th>
                <th style="width: 14%; text-align: right;">{{ $customer['totals']['discountTotal'] }}</th>
                <th style="width: 14%; text-align: right;">{{ $customer['totals']['outstandingTotal'] }}</th>
                <th style="width: 14%; text-align: right;">&nbsp;</th>
                </tr>
            </table>
        @endforeach
        <hr class="double_hr">
    </div>

</body>

</html>
