<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 10px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>STOCK IN (GRN) REPORT</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Category : {{ $category ?? '' }} | Item : {{ $item ?? '' }}</p>
    <table>
        <tr>
            <th>Ref #</th>
            <th>Date</th>
            <th>Item</th>
            <th style="text-align: right;">Qty</th>
        </tr>
        <?php
        $total_qty = 0;
        ?>
        @foreach ($grns as $grn)
            <tr>
                @php
                    $total_qty += $grn->delivered_qty;
                @endphp
                <td>{{ $grn->grn_code }}</td>
                <td>{{ $grn->grn_date }}</td>
                <td>{{ $grn->description }}</td>
                <td style="text-align: right;">{{ number_format($grn->delivered_qty) }}</td>
            </tr>
        @endforeach
        <tr>
            <th style="text-align: center;" colspan="3">Total</th>
            <th style="text-align: right;">{{ number_format($total_qty) }}</th>
        </tr>
    </table>
</body>

</html>
