<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            border: 1px solid #ddd;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>{{ $reportName }}</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Rep : {{ $rep ?? '' }}</p>
    <table>
        <tr>
            <th>#</th>
            <th style="width:25%;">Date</th>
            <th style="width:25%; text-align: right;">Bill Total</th>
            <th style="width:25%; text-align: right;">Returns</th>
            <th style="width:25%; text-align: right;">Balance</th>
        </tr>
        <?php
        $total = 0;
        $invoice_balance_total = 0;
        $invoice_returned_amount_total = 0;
        $total_invoice_return = 0;
        ?>
        @foreach ($invoices as $invoice)

            <tr>
                @php

                $invoice_return =  $invoice['credit_notes_total'] + $invoice['discount_total'];
                $invoice_balance = $invoice['invoice_total'] - $invoice_return ;

                $total_invoice_return += $invoice_return;
                $invoice_balance_total += $invoice_balance;
                $total += $invoice['invoice_total'];

                @endphp
                <td>{{ $loop->iteration }}</td>
                <td style="width:25%;">{{ $invoice['date'] }}</td>
                <td style="width:25%;text-align: right;">  {{ \App\Http\Helper::formatPrice($invoice['invoice_total']) }}</td>
                <td style="width:25%;text-align: right;">  {{ \App\Http\Helper::formatPrice($invoice_return) }}</td>
                <td style="width:25%;text-align: right;">{{ \App\Http\Helper::formatPrice($invoice_balance) }}</td>
            </tr>
        @endforeach
        <tr>
            <th style="text-align: center;" colspan="2">Total</th>
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($total) }}</th>
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($total_invoice_return) }}</th>
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($invoice_balance_total) }}</th>
        </tr>
    </table>
</body>

</html>






{{-- <!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 12px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .double_hr {
            overflow: visible;
            /* For IE */
            padding: 0;
            border: none;
            border-top: medium double #333;
            color: #333;
            text-align: center;
            margin-bottom: 10px;
        }

        hr {
            margin: 3px;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>Sales Commission Report</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Customer : {{ $customer_name ?? '' }} | Rep : {{ $rep ?? '' }}</p>
    <table>
        <tr>
            <th style="">Invoice #</th>
            <th style="text-align: right;">Total</th>
            <th style="text-align: right;">Return</th>
            <th style="text-align: right;">Balance</th>
        </tr>
    </table>
    @php
        $full_total = 0;
        $full_return = 0;
        $full_balance = 0;
    @endphp
    @foreach ($customers as $customer)
        @if ($customer->invoices->isNotEmpty())
            <strong>Customer :</strong> {{ $customer->company_name ?? '' }} | <strong>Rep:</strong>
            {{ $customer->rep->fname ?? '' }} {{ $customer->rep->lname ?? '' }} <br>
            <hr>
            <table>
                @php
                    $total = 0;
                    $return = 0;
                    $balance = 0;
                @endphp
                @foreach ($customer->invoices as $invoice)
                    @php
                    $invoice_total= \App\Utils\CommonUtil::calculateInvoiceTotal($invoice->id);
                    $invoice_return_total= \App\Utils\CommonUtil::calculateSalesCommissionInvoiceReturnTotal($invoice->id);
                    $bulk_discount_invoice_total= \App\Utils\CommonUtil::calculateSalesCommissionBulkDiscountTotal($invoice->id);

                        $line_total = $invoice_total;
                        // $line_return = $invoice->invoice_returns->sum('total') + $invoice->bulk_discount_invoices->sum('discount');
                        $line_return = $invoice_return_total + $bulk_discount_invoice_total;
                        $line_balance = $line_total - $line_return;
                        $total += $line_total;
                        $return += $line_return;
                        $balance += $line_balance;
                        $full_total += $line_total;
                        $full_return += $line_return;
                        $full_balance += $line_balance;
                    @endphp
                    <tr>
                        <td style="">{{ $invoice->invoice_code }} {{ $invoice->invoice_date }}</td>
                        <td style="text-align: right;">
                            {{ \App\Http\Helper::formatPrice($line_total) }}
                        </td>
                        <td style="text-align: right;">
                            {{ \App\Http\Helper::formatPrice($line_return) }}
                        </td>
                        <td style="text-align: right;">
                            {{ \App\Http\Helper::formatPrice($line_balance) }}
                        </td>
                    </tr>
                @endforeach
                <tr>
                    <th style="">Total</th>
                    <th style="text-align: right;">
                        {{ \App\Http\Helper::formatPrice($total) }}
                    </th>
                    <th style="text-align: right;">
                        {{ \App\Http\Helper::formatPrice($return) }}
                    </th>
                    <th style="text-align: right;">
                        {{ \App\Http\Helper::formatPrice($balance) }}
                    </th>
                </tr>
            </table>
            <hr class="double_hr">
        @endif
    @endforeach
    <table>
        <tr>
            <th style="">Full Total</th>
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($full_total) }}
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($full_return) }}
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($full_balance) }}
            </th>
        </tr>
    </table>
</body>

</html> --}}
