<!DOCTYPE html>
<html lang="en">

<head>
    <style>
        body {
            font-size: 11px;
            font-family: sans-serif;
            text-transform: uppercase;
        }

        table {

            border-collapse: collapse;
            width: 100%;
            padding-bottom: 10px;
            padding-top: 0px;
        }

        td,
        th {
            border: 1px solid #ddd;
            padding: 4px;
            font-size: 10px;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        th {
            /*    padding-top: 12px;
                padding-bottom: 12px;*/
            text-align: left;
            background-color: #f4f9f3;
            color: black;
        }

        .table_title {
            margin-bottom: 0px;
            padding-bottom: 5px;
        }

        .logo {
            margin-right: 30px;
            margin-bottom: 25px;
        }
    </style>

</head>

<body>
    {!! getLogo() !!}
    <H2>Collection Commission Report</H2>
    <p>Filtered by:</p>
    <p>From Date : {{ $from_date ?? '' }} | To Date : {{ $end_date ?? '' }}</p>
    <p>Rep : {{ $rep ?? '' }}</p>
    <table>
        <tr>
            <th>Order #</th>
            <th>Date</th>
            <th>Customer</th>
            <th>Receipt</th>
            <th>Payment Date</th>
            <th>Post Day</th>
            <th>Days</th>
            <th style="text-align: right;">Collection</th>
        </tr>
        <?php
        $total = 0;
        ?>
        @foreach ($invoices as $invoice)
            @if ($invoice->collection != 0)
                <tr>
                    @php
                        $total += $invoice->collection;
                    @endphp
                    <td>{{ $invoice->invoice_code }}</td>
                    <td>{{ $invoice->invoice_date }}</td>
                    <td>{{ $invoice->company_name . '-' . $invoice->name_en }}</td>
                    <td>{{ $invoice->payment_code }}</td>
                    <td>{{ $invoice->payment_date }}</td>
                    <td>{{ $invoice->cheque_date }}</td>
                    <td>{{ $invoice->days }}</td>
                    <td style="text-align: right;">{{ \App\Http\Helper::formatPrice($invoice->collection) }}</td>
                </tr>
            @endif
        @endforeach
        <tr>
            <th style="text-align: center;" colspan="7">Total</th>
            <th style="text-align: right;">{{ \App\Http\Helper::formatPrice($total) }}</th>
        </tr>
    </table>
</body>

</html>
