<?php

namespace Pramix\XReports\Models;

use App\Utils\CommonUtil;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Pramix\XCustomer\Models\CustomerModel;
use PDF;
use DB;
use Pramix\XProduct\Models\ProductsModel;
use Pramix\XPayment\Models\ChequeModel;

class ReportsModel extends Model
{
    public static function getReportTimeRange($filter_details)
    {
        $invoice_date_range = $filter_details['date_range'];
        $sales_order_from_date = $filter_details['date_from'];
        $sales_order_end_date = $filter_details['date_to'];

        $date_range = array();

        switch ($invoice_date_range) {
            case "today":
                $date_range['from_date'] = Carbon::now();
                $date_range['end_date'] = Carbon::now();
                break;
            case "this_month":
                $date_range['from_date'] = Carbon::now()->startOfMonth();
                $date_range['end_date'] = Carbon::now();
                break;
            case "this_quarter":
                $now = Carbon::now();
                $date_range['from_date'] = $now->startOfQuarter();
                $date_range['end_date'] = Carbon::now();
                break;
            case "this_year":
                $date_range['from_date'] = Carbon::now()->startOfYear();
                $date_range['end_date'] = Carbon::now();
                break;
            case "last_7_days":
                $date_range['from_date'] = Carbon::now()->subWeek();
                $date_range['end_date'] = Carbon::now();
                break;
            case "last_30_days":
                $date_range['from_date'] = Carbon::now()->subMonth();
                $date_range['end_date'] = Carbon::now();
                break;
            case "custom_date_range":
                $date_range['from_date'] = Carbon::createFromFormat('Y-m-d', $sales_order_from_date);
                $date_range['end_date'] = Carbon::createFromFormat('Y-m-d', $sales_order_end_date);
                break;
        }

        return $date_range;
    }


    public static function generateChequeReturnReport($filter_details)
    {

        $user = Auth::user();

        $customers = DB::table('customer')
                                ->join('cheque', 'cheque.customer_id', '=', 'customer.id')
                                ->join('users', 'customer.rep_id', '=', 'users.id')
                                ->selectRaw(
                                    'DISTINCT pramix_customer.company_name,
                                    pramix_customer.id AS customer_id,
                                    pramix_customer.business_name,
                                    pramix_customer.mobile,
                                    pramix_users.fname AS rep_fname,
                                    pramix_users.lname AS rep_lname')
                                ->where('customer.status', 'A')
                                ->where('cheque.status', 2);

        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $customers->where('customer.invoice_type', '35');
        }
        if ($filter_details['customer_id'] != ''){
            $customers->where('customer.id',$filter_details['customer_id']);
        }
        if ($filter_details['rep'] != ''){
            $customers->where('customer.rep_id',$filter_details['rep']);
        }

        $customers = $customers->get();
        // dd($customers);
        // foreach($customers as $customer)
        // {
        //     $cheques = ChequeModel::where('customer_id', $customer->customer_id)->where('status',2)->get()->toArray();
        //     $return_cheques[$customer->customer_id] = $cheques;
        // }
        // dd($return_cheques);
        // ChequeModel::where('customer_id', $customer->customer_id)->where('status',2)->get();

        $pdf = PDF::loadView('xreports::sales.cheque_return_outstanding.cheque_return_outstanding_report', [
            'customers' => $customers,
        ])->setPaper('letter', 'portrait');
        $file_name = 'cheque_return_outstanding_report' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }


    public static function generateLowStockProductsReport($filter_details)
    {

        $low_stock_products = ProductsModel::where('qty_on_hand', '<=', 'reorder_point')->with('category')->where('type', 'stock');

        if ($filter_details['product_catagory'] != '')
            $low_stock_products->where('category_id', $filter_details['product_catagory']);

        $low_stock_products = $low_stock_products->get();


        $pdf = PDF::loadView('xreports::inventory.low_stock_products_report.low_stock_products', array('products' => $low_stock_products))
            ->setPaper('letter', 'portrait');


        $file_name = 'low_stock_products' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/inventory');
        return $path;
    }
}
