<?php

namespace Pramix\XReports\Models;

use App\Utils\CommonUtil;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use PDF;
use Pramix\XCustomer\Models\CustomerModel;
use Pramix\XGeneral\Models\AddressModel;
use Pramix\XInvoice\Models\InvoiceModel;
use App\ChequeReturnPayment;
use App\Http\Helper;
use Pramix\XUser\Models\User;

class CustomerOutstandingReport extends Model
{
    public static function generateCustomerOutstandingReport($filter_details)
    {
        // dd($filter_details);
        $customers = CustomerModel::orderBy('business_name');

        if ($filter_details['customer_id'] != '') {
            $customers->where('id', $filter_details['customer_id']);
        }

        if ($filter_details['customer_district_id'] != '') {
            $customers->whereHas('customerAddress', function ($q) use ($filter_details) {
                $q->where('district_id', $filter_details['customer_district_id']);
            });
        }

        if ($filter_details['rep'] != '') {
            $customers->where('rep_id', $filter_details['rep']);
        }

        $customers = $customers->get();

        $reportData = array();

        $test = array();


        foreach ($customers as $customer) {

            $invoices = InvoiceModel::where('customer_id', $customer->id)->where('status', 'I')->whereNotNull('invoice_code');

            if ($filter_details['invoice_rep'] != '') {
                $invoices->where('rep_id', $filter_details['invoice_rep']);
            }

            $user = Auth::user();
            if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
                $invoices->where('user_type', '35');
            }

            $invoices = $invoices->orderBy('id')->get();

            $dataObject = array(
                'customer' => $customer,
                'invoices' => array(),
                'totals' => array()
            );

            $hasOutStandingInvoices = false;
            $total_invoice_amount = 0;
            $total__paid_amount = 0;
            $total__return_amount = 0;
            $total_balance_total = 0;
            $total_discount_amount = 0;


            if (count($invoices) > 0) {
                foreach ($invoices as $invoice) {
                    $outstanding = CommonUtil::calculateInvoiceOutstanding($invoice->id);
                    $test[] = [
                        'id' => $invoice->id,
                        'out' => $outstanding
                    ];
                    if ($outstanding > 0 || $outstanding < 0) {
                        $total_paid = CommonUtil::calculatePaidAmountInvoice($invoice->id);
                        $total_returns = CommonUtil::calculateTotalReturnAmountInvoice($invoice->id);
                        $total_discount = CommonUtil::calculateTotalDiscountAndCreditInvoice($invoice->id);
                        $count_days = Carbon::parse($invoice->invoice_date)->diffInDays(\Carbon\Carbon::now(), false);

                        $total_invoice_amount += $invoice->total;
                        $total__paid_amount += $total_paid;
                        $total__return_amount += $total_returns;
                        $total_discount_amount += $total_discount;
                        $total_balance_total += $outstanding;

                        $dataObject['invoices'][] = [
                            'invoiceCode' => $invoice->invoice_code,
                            'date' => $invoice->invoice_date,
                            'remarks' => $invoice->remarks ? $invoice->remarks : 'N/A',
                            'total' => Helper::formatPrice($invoice->total),
                            'totalPaid' => Helper::formatPrice($total_paid),
                            'totalReturns' => Helper::formatPrice($total_returns),
                            'totalDiscounts' => Helper::formatPrice($total_discount),
                            'outstanding' => Helper::formatPrice($outstanding),
                            'daysCount' => $count_days
                        ];
                        $hasOutStandingInvoices = true;
                    }
                }

                $dataObject['totals'] = [
                    'invoiceTotal' => Helper::formatPrice($total_invoice_amount),
                    'paidTotal' => Helper::formatPrice($total__paid_amount),
                    'returnTotal' => Helper::formatPrice($total__return_amount),
                    'discountTotal' => Helper::formatPrice($total_discount_amount),
                    'outstandingTotal' => Helper::formatPrice($total_balance_total),
                ];

                if ($hasOutStandingInvoices) {
                    $reportData[] = $dataObject;
                }
            }
        }

        $repName = 'N/A';
        if ($filter_details['invoice_rep'] != '') {
            $rep = User::find($filter_details['invoice_rep']);
            $repName = $rep->username . ' - ' . $rep->fname;
        }

        if ($filter_details['rep'] != '') {
            $rep = User::find($filter_details['rep']);
            $repName = $rep->username . ' - ' . $rep->fname;
        }

        $pdf = PDF::loadView('xreports::sales.customer_outstanding.customer_outstanding_report', array('customers' => $reportData, 'repName' => $repName))
            ->setPaper('letter', 'portrait');

        $file_name = 'customer_outstanding' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }

    public static function customerOutstandingReportSendEmail($filter_details, $username)
    {
        // dd($filter_details);
        $customers = CustomerModel::orderBy('business_name');

        if ($filter_details['customer_id'] != '') {
            $customers->where('id', $filter_details['customer_id']);
        }

        if ($filter_details['customer_district_id'] != '') {
            $customers->whereHas('customerAddress', function ($q) use ($filter_details) {
                $q->where('district_id', $filter_details['customer_district_id']);
            });
        }

        if ($filter_details['rep'] != '') {
            $customers->where('rep_id', $filter_details['rep']);
        }

        $customers = $customers->get();

        $reportData = array();

        $test = array();


        foreach ($customers as $customer) {

            $invoices = InvoiceModel::where('customer_id', $customer->id)->where('status', 'I')->whereNotNull('invoice_code');

            if ($filter_details['invoice_rep'] != '') {
                $invoices->where('rep_id', $filter_details['invoice_rep']);
            }

            if ($username == 'user35'|| $username == 'USER30@GMAIL.COM' || $username == 'USER33@GMAIL.COM') {
                $invoices->where('user_type', '35');
            }

            $invoices = $invoices->orderBy('id')->get();

            $dataObject = array(
                'customer' => $customer,
                'invoices' => array(),
                'totals' => array()
            );

            $hasOutStandingInvoices = false;
            $total_invoice_amount = 0;
            $total__paid_amount = 0;
            $total__return_amount = 0;
            $total_balance_total = 0;
            $total_discount_amount = 0;


            if (count($invoices) > 0) {
                foreach ($invoices as $invoice) {
                    $outstanding = CommonUtil::calculateInvoiceOutstanding($invoice->id);
                    $test[] = [
                        'id' => $invoice->id,
                        'out' => $outstanding
                    ];
                    if ($outstanding > 0 || $outstanding < 0) {
                        $total_paid = CommonUtil::calculatePaidAmountInvoice($invoice->id);
                        $total_returns = CommonUtil::calculateTotalReturnAmountInvoice($invoice->id);
                        $total_discount = CommonUtil::calculateTotalDiscountAndCreditInvoice($invoice->id);
                        $count_days = Carbon::parse($invoice->invoice_date)->diffInDays(\Carbon\Carbon::now(), false);

                        $total_invoice_amount += $invoice->total;
                        $total__paid_amount += $total_paid;
                        $total__return_amount += $total_returns;
                        $total_discount_amount += $total_discount;
                        $total_balance_total += $outstanding;

                        $dataObject['invoices'][] = [
                            'invoiceCode' => $invoice->invoice_code,
                            'date' => $invoice->invoice_date,
                            'remarks' => $invoice->remarks ? $invoice->remarks : 'N/A',
                            'total' => Helper::formatPrice($invoice->total),
                            'totalPaid' => Helper::formatPrice($total_paid),
                            'totalReturns' => Helper::formatPrice($total_returns),
                            'totalDiscounts' => Helper::formatPrice($total_discount),
                            'outstanding' => Helper::formatPrice($outstanding),
                            'daysCount' => $count_days
                        ];
                        $hasOutStandingInvoices = true;
                    }
                }

                $dataObject['totals'] = [
                    'invoiceTotal' => Helper::formatPrice($total_invoice_amount),
                    'paidTotal' => Helper::formatPrice($total__paid_amount),
                    'returnTotal' => Helper::formatPrice($total__return_amount),
                    'discountTotal' => Helper::formatPrice($total_discount_amount),
                    'outstandingTotal' => Helper::formatPrice($total_balance_total),
                ];

                if ($hasOutStandingInvoices) {
                    $reportData[] = $dataObject;
                }
            }
        }

        $repName = 'N/A';
        if ($filter_details['invoice_rep'] != '') {
            $rep = User::find($filter_details['invoice_rep']);
            $repName = $rep->username . ' - ' . $rep->fname;
        }

        if ($filter_details['rep'] != '') {
            $rep = User::find($filter_details['rep']);
            $repName = $rep->username . ' - ' . $rep->fname;
        }

        $pdf = PDF::loadView('xreports::sales.customer_outstanding.customer_outstanding_report', array('customers' => $reportData, 'repName' => $repName))
            ->setPaper('letter', 'portrait');

        $file_name = 'customer_outstanding' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }

    public static function generateCustomerOutstandingPeriodWiseReport($filter_details)
    {

        $commonUtil = new CommonUtil();

        $customers = CustomerModel::with('activeOutstandingInvoices')->with('customerAddress')->with('rep');
        $user = Auth::user();
        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $customers->where('invoice_type', '35');
        }
        //        $customers->whereHas('activeOutstandingInvoices', function ($q) {
        //            $q->whereColumn('total', '>', 'paid_amount');
        //            $q->where('invoice_code', '<>', '');
        //        });
        if ($filter_details['customer_id'] != '')
            $customers->where('id', $filter_details['customer_id']);

        if ($filter_details['customer_district_id'] != '') {
            $customers->whereHas('customerAddress', function ($q) use ($filter_details) {
                $q->where('district_id', $filter_details['customer_district_id']);
            });
        }

        if ($filter_details['rep'] != '')
            $customers->where('rep_id', $filter_details['rep']);

        if ($filter_details['invoice_rep'] != '') {
            $customers->whereHas('activeOutstandingInvoices', function ($q) use ($filter_details) {
                $q->where('rep_id', $filter_details['invoice_rep']);
            });
        }

        $customers = $customers->get();

        foreach ($customers as $customer) {
            //            if ($user->username == 'user35') {
            $all_invoices = InvoiceModel::where('customer_id', $customer->id)
                ->where('total', '>', 'paid_amount')
                ->where('invoice_code', '!=', '')
                ->get();

            if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
                $all_invoices = $all_invoices->where('user_type', '35');
            }

            $customer['invoice_total'] = $commonUtil->calculateInvoiceOutstandingUsingInvoiceArray($all_invoices);

            $less_30_invoices = InvoiceModel::where('customer_id', $customer->id)
                ->whereBetween('invoice_date', [Carbon::now()->subDays(30), Carbon::now()])
                ->where('invoice_code', '!=', '')
                ->get();

            if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
                $less_30_invoices = $less_30_invoices->where('user_type', '35');
            }

            $customer['less_30_days'] = $commonUtil->calculateInvoiceOutstandingUsingInvoiceArray($less_30_invoices);

            $invoice_31_60 = InvoiceModel::where('customer_id', $customer->id)
                ->whereBetween('invoice_date', [Carbon::now()->subDays(60), Carbon::now()->subDays(31)])
                ->where('invoice_code', '!=', '')
                ->get();

            if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
                $invoice_31_60 = $invoice_31_60->where('user_type', '35');
            }

            $customer['between_31_60_days'] =  $commonUtil->calculateInvoiceOutstandingUsingInvoiceArray($invoice_31_60);

            $between_61_90_days = InvoiceModel::where('customer_id', $customer->id)
                ->whereBetween('invoice_date', [Carbon::now()->subDays(90), Carbon::now()->subDays(61)])
                ->where('invoice_code', '!=', '')
                ->get();

            if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
                $between_61_90_days = $between_61_90_days->where('user_type', '35');
            }

            $customer['between_61_90_days'] = $commonUtil->calculateInvoiceOutstandingUsingInvoiceArray($between_61_90_days);

            $over_91 = InvoiceModel::where('customer_id', $customer->id)
                ->where('invoice_date', '<', Carbon::now()->subDays(90))
                ->where('invoice_code', '!=', '')
                ->get();

            if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
                $over_91 = $over_91->where('user_type', '35');
            }

            $customer['over_91'] = $commonUtil->calculateInvoiceOutstandingUsingInvoiceArray($over_91);

            //            } else {
            //                $customer['invoice_total'] = InvoiceModel::where('customer_id', $customer->id)
            //                    ->where('total', '>', 'paid_amount')
            //                    ->where('invoice_code', '!=', '')
            //                    ->sum('balance');
            //                $customer['less_30_days'] = InvoiceModel::where('customer_id', $customer->id)
            //                    ->whereBetween('invoice_date', [Carbon::now()->subDays(30), Carbon::now()])
            //                    ->where('invoice_code', '!=', '')
            //                    ->where('total', '>', 'paid_amount')
            //                    ->sum('balance');
            //                $customer['between_31_60_days'] = InvoiceModel::where('customer_id', $customer->id)
            //                    ->whereBetween('invoice_date', [Carbon::now()->subDays(60), Carbon::now()->subDays(31)])
            //                    ->where('invoice_code', '!=', '')
            //                    ->where('total', '>', 'paid_amount')
            //                    ->sum('balance');
            //                $customer['between_61_90_days'] = InvoiceModel::where('customer_id', $customer->id)
            //                    ->whereBetween('invoice_date', [Carbon::now()->subDays(90), Carbon::now()->subDays(61)])
            //                    ->where('invoice_code', '!=', '')->where('total', '>', 'paid_amount')
            //                    ->sum('balance');
            //                $customer['over_91'] = InvoiceModel::where('customer_id', $customer->id)
            //                    ->where('invoice_date', '<', Carbon::now()->subDays(90))->where('invoice_code', '!=', '')
            //                    ->where('total', '>', 'paid_amount')
            //                    ->sum('balance');
            //            }
        }


        //        return $customers;

        $pdf = PDF::loadView('xreports::sales.customer_outstanding_period_wise.customer_outstanding_period_wise_report', array('customers' => $customers))
            ->setPaper('letter', 'portrait');

        $file_name = 'customer_outstanding_period_wise' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }
}
