@extends('layouts.app')

@section('content')
<div class="dashboard-wrapper">
    <div class="top-bar clearfix">
        <div class="row gutter">
            <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                <div class="page-title">
                    <h4>Show Credit Note</h4>
                </div>
            </div>
        </div>
    </div>
    <div class="main-container">

<div class="row gutter">
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Customer Information</h5>
          <p class="card-text">Name: {{$invoice_return->customer->company_name}}</p>
          <p class="card-text">Code: {{$invoice_return->customer->business_name}}</p>
          <p class="card-text">Return from Invoice: {{$invoice_return->invoice->invoice_code}}</p>
        </div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Return Details</h5>
          <p class="card-text">Return Code: {{$invoice_return->invoice_return_code}}</p>
          <p class="card-text">Return Date: {{$invoice_return->invoice_return_date}}</p>
          <p class="card-text">Remarks: {{$invoice_return->remarks}}</p>
        </div>
      </div>
    </div>
    <div class="card mt-3">
        <div class="card-body">
          <h5 class="card-title">Returned Products</h5>
          <table class="table">
            <thead>
              <tr>

                <th>Description</th>
                <th class="text-right">Quantity</th>
                <th class="text-right">Unit Price</th>
                <th class="text-right">Discount</th>
                <th class="text-center">Discount Type</th>
                <th class="text-right">Subtotal</th>
              </tr>
            </thead>
            <tbody>
                @foreach ($invoice_return->invoiceReturnProducts as $invoice_return_product)
                <tr>
                    <td class="text-center">{{$invoice_return_product->description}}</td>
                    <td class="text-right">{{$invoice_return_product->qty}}</td>
                    <td class="text-right">Rs. {{number_format($invoice_return_product->unit_price,2)}}</td>
                    <td class="text-right">Rs. {{number_format($invoice_return_product->discount,2)}}</td>
                    <td class="text-center">{{$invoice_return_product->discount_type}}</td>
                    <td class="text-right">Rs. {{number_format($invoice_return_product->sub_total,2)}}</td>
                </tr>
                @endforeach


              <!-- Add more rows for additional returned products -->
            </tbody>
          </table>
        </div>
      </div>

    <div class="card mt-3">
        <div class="card-body">
          <h5 class="card-title">CREDIT NOTE DEDUCT FROM</h5>
          <table class="table">
            <thead>
              <tr>

                <th >Invoice return code</th>
                <th class="text-right">Invoice Return Date</th>
                <th class="text-right">Deduction Total</th>
                <th class="text-center">Remarks</th>

              </tr>
            </thead>
            <tbody>
                @foreach ($deduction_invoices as $deduction_invoice)
                <tr>
                   
                    <td class="text-center">{{$deduction_invoice->invoice_return_code}}</td>
                    <td class="text-right">{{$deduction_invoice->invoice_return_date}}</td>
                    <td class="text-right">RS. {{number_format($deduction_invoice->total,2)}}</td>
                    <td class="text-center">{{$deduction_invoice->remarks}}</td>
                </tr>
                @endforeach


              <!-- Add more rows for additional returned products -->
            </tbody>
          </table>
        </div>
      </div>
  </div>
    </div>
</div>
@endsection
