@extends('layouts.app')

@section('content')
    <input type="hidden" name="page" id="page" value="{{ $page ?? '' }}">
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>{{ __('xinvoice::invoice.headings.credit_note') }}</h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    @can('ADD_CREDIT_NOTE')
                        <ul class="right-stats" id="mini-nav-right">

                            <button class="btn btn-success" id="select_invoice_product_btn">Quick Search Product</button>

                            <a href="{{ url('invoice_return/create') }}" class="btn btn-primary"><i class="fa fa-plus"
                                    aria-hidden="true"></i>
                                {{ __('xinvoice::invoice.buttons.create_credit_note') }}</a>

                        </ul>
                    @endcan
                </div>
            </div>
        </div>

        <div class="main-container">
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="{{ route('invoice_return.index') }}">

                                <div class="form-inline data_list_filters">

                                    <div class="form-group">
                                        <label for="">Number </label> <br>
                                        <input type="text" name="invoice_return_code" value="{{request('invoice_return_code')}}" class="form-control" id="searchinvoiceycode"
                                            placeholder="Return #">
                                    </div>
                                    <div class="form-group">
                                        <label for="">Invoice Number</label> <br>
                                        <input type="text" name="rtn_invoice_code" value="{{request('rtn_invoice_code')}}" class="form-control" id="searchinvoicecode"
                                        placeholder="Invoice #">
                                    </div>
                                    <div class="form-group">
                                        <div class="col-sm-12">
                                            <br><label for="">Date</label><br>
                                            <input name="invoice_return_date" value="{{request('invoice_return_date')}}" style="margin-bottom: 20px;" class="form-control dates">
                                            {{-- {{ formDate(__(''), 'invoice_date_created', Carbon\Carbon::today()->format('Y-m-d'), ['style' => 'margin-bottom: 20px;','class' => 'form-control', 'id' => 'invoice_date_created']) }} --}}
                                        </div>
                                    </div>
                                    <div class="form-group">

                                        <label for="">Select Rep</label> <br>

                                        <select name="rep_id" id="rep" class="form-control select2 select3">
                                            <option value="">Select Rep</option>
                                            @foreach($roles as $role)
                                            {{-- - {{$role ->fname }} --}}
                                            <option value="{{ $role->id }}" @if(request('rep') == $role->id) selected @endif>{{ $role->username }} - {{$role ->fname }}  </option>
                                        @endforeach
                                        </select>

                                    </div>
                                    <div class="form-group">
                                        <label for="">Customer</label> <br>
                                        <input type="text" name="customer_name" class="form-control" id="searchcustomername"
                                            placeholder="{{ __('xinvoice::invoice.labels.customer') }}" value="{{request('customer_name')}}">
                                    </div>
                                    <div class="form-group">
                                        <div class="btn-group btn-group-toggle" data-toggle="buttons">
                                            <label class="btn btn-primary active">
                                                <input type="radio" name="invoice_rtn_status" value=""  @if(request('invoice_rtn_status') == '') checked @endif> All
                                            </label>
                                            <label class="btn btn-primary" id="all_status" data-toggle="tooltip"
                                                data-placement="top" title="Status">
                                                <input type="radio" name="invoice_rtn_status" value="D" @if(request('invoice_rtn_status') == 'D') checked @endif> Draft
                                            </label>
                                            <label class="btn btn-primary ">
                                                <input type="radio" name="invoice_rtn_status" value="A" @if(request('invoice_rtn_status') == 'A') checked @endif> Completed
                                            </label>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        &nbsp;&nbsp;<button type="submit" style="margin-top: 15px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Submit</button>
                                    </div>
                                    <div class="form-group">
                                        &nbsp;&nbsp; <a href="{{ route('invoice_return.index') }}" style="margin-top: 15px;" class="btn btn-gradient-primary waves-effect waves-light float-right mb-3">Reset</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <div class="table-responsive">
                        <table id="invoice_return_list_table" class="table table-striped table-bordered no-margin"
                            cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th hidden></th>
                                    <th>{{ __('xinvoice::invoice.labels.invoice_return_code') }}</th>
                                    <th>Return Date</th>
                                    <th>{{ __('xinvoice::invoice.labels.customer') }}</th>
                                    <th>Rep</th>
                                    <th>{{ __('xinvoice::invoice.labels.total') }}</th>
                                    <th>{{ __('xinvoice::invoice.labels.status') }}</th>
                                    <th>{{ __('xinvoice::invoice.labels.remarks') }}</th>
                                    <th>{{ __('common.labels.action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($invoice_returns as $invoice_return )
                                    <tr>
                                        <td hidden>{{$invoice_return->id}}</td>
                                        <td>{{$invoice_return->invoice_return_code}}</td>
                                        <td>{{$invoice_return->invoice_return_date}}</td>
                                        <td>
                                            @if (isset($invoice_return->customer))
                                                {{ $invoice_return->customer->company_name }}
                                            @else

                                            @endif
                                        </td>
                                        <td>
                                            @if (isset($invoice_return->customer->rep) && isset($invoice_return->customer->rep->username))
                                                {{ $invoice_return->customer->rep->username }}
                                            @else
                                                -
                                            @endif
                                        </td>
                                        <td>{{App\Http\Helper::formatPrice($invoice_return->total)}}</td>
                                        <td>
                                            @if ($invoice_return->status == 'D')
                                                <span class="text-danger"><strong>Draft</strong></span>
                                            @elseif ($invoice_return->status == 'A')
                                                <span class="text-success"><strong>Completed</strong></span>
                                            @else
                                                -
                                            @endif
                                        </td>
                                        <td>{{$invoice_return->remarks}}</td>
                                        <td>
                                            @php
                                               $edit_invoicer_permission = false;
                                                $delete_credit_note_permission = false;
                                                if (Auth::user()->can('EDIT_CREDIT_NOTE')) {
                                                    $edit_invoicer_permission = true;
                                                }
                                                if (auth()->user()->can('DELETE_CREDIT_NOTE')) {
                                                    $delete_credit_note_permission = true;
                                                }
                                            @endphp
                                            @if ($edit_invoicer_permission)

                                            <a class="btn btn-info btn-xs" href="{{ url('/invoice_return/' . $invoice_return->id . '/show') }}" id="edit_customer" data-toggle="tooltip" data-placement="right" title="View Invoice Return">
                                                <i class="fa fa-eye"></i>
                                            </a>

                                            @endif
                                            @if ($delete_credit_note_permission)
                                                &nbsp;<button class="delete_credit_note btn btn-danger btn-xs" data-toggle="tooltip" data-placement="right" title="Delete Credit Note" data-original-title="Delete" aria-describedby="tooltip934027"><i class="fa fa-trash-o" aria-hidden="true"></i></button>
                                            @endif
                                        </td>

                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        <div class="d-flex justify-content-end">
                            {{ $invoice_returns->appends($_GET)->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('custom_script')
    <script>
        $(document).ready(function() {

            $('#all_status').tooltip('show');

            // var invoice_return_list_table = $('#invoice_return_list_table').DataTable({
            //     'iDisplayLength': 15,
            //     ajax: '{!! route('get.invoice_return') !!}',
            //     order: [
            //         [0, "desc"]
            //     ],

            //     columns: [{
            //             data: 'id',
            //             name: 'id',
            //             'bVisible': false
            //         },
            //         {
            //             data: 'invoice_return_code',
            //             name: 'invoice_return_code'
            //         },
            //         {
            //             data: 'invoice_code',
            //             name: 'invoice_code'
            //         },
            //         {
            //             data: 'invoice_return_date',
            //             name: 'invoice_return_date'
            //         },
            //         {
            //             data: 'customer',
            //             name: 'customer'
            //         },
            //         {
            //             data: 'rep',
            //             name: 'rep'
            //         },
            //         {
            //             data: 'total',
            //             name: 'total',
            //             className: 'dt-body-right'
            //         },
            //         {
            //             data: 'status',
            //             name: 'status'
            //         },
            //         {
            //             data: 'remarks',
            //             name: 'remarks'
            //         },

            //         {
            //             data: 'action',
            //             name: 'action'
            //         },
            //     ]
            // });


            $('#searchinvoiceycode').on('keyup', function() {
                invoice_return_list_table.column(1)
                    .search(this.value)
                    .draw();
            });
            $('#searchinvoicecode').on('keyup', function(){
                invoice_return_list_table.column(2)
                    .search(this.value)
                    .draw();
            })
            $('#invoice_date_created').on('change', function(){
                invoice_return_list_table.column(3)
                    .search(this.value)
                    .draw();
            })
            $('#searchcustomername').on('keyup', function() {
                invoice_return_list_table.column(4)
                    .search(this.value)
                    .draw();
            });
            $('#searchrep').on('keyup', function() {
                invoice_return_list_table.column(5)
                    .search(this.value)
                    .draw();
            });

            $('input[type=radio][name=invoice_status]').change(function() {
                invoice_return_list_table.column(5)
                    .search(this.value)
                    .draw();
            });

            $(document).on('click', '.delete_credit_note', function(e) {
                var data = {};
                var firstTDValue = $(this).closest('tr').find('td:first').text().trim();
                data['id'] = firstTDValue;
                var parent = $(this).parents('tr');
                var delete_confirm = $.confirm({
                    title: "Delete Return Note",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function() {

                                e.preventDefault();
                                var params = {

                                };

                                $.ajax({
                                    url: BASE + 'invoice_return/' + data['id'],
                                    type: 'DELETE',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {
                                            delete_confirm.close();
                                            notification(response);
                                            location.reload();
                                        }
                                    },
                                    error: function(errors) {}
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function() {}
                    }
                });
            });

        });
    </script>
@endsection
