@extends('layouts.app')

@section('content')
    <div class="dashboard-wrapper">
        <div class="top-bar clearfix">
            <div class="row gutter">
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    <div class="page-title">
                        <h4>Discount & Credit</h4>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12">
                    @can('CREATE_DISCOUNT_AND_CREDIT')
                        <ul class="right-stats" id="mini-nav-right">
                            <a href="{{ route('bulk_discounts.create') }}" class="btn btn-primary"><i class="fa fa-plus"
                                    aria-hidden="true"></i>
                                Create Discount & Credit</a>
                        </ul>
                    @endcan
                </div>
            </div>
        </div>

        <div class="main-container">
            <div class="row gutter">
                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                    <div class="card">

                        <div class="card-body">
                            <div class="form-inline data_list_filters">

                                <div class="form-group">
                                    <label for="">Invoice Number</label> <br>
                                    <input type="text" class="form-control" id="searchinvoicecode"
                                        placeholder="Return invoice #">
                                </div>
                                <div class="form-group">
                                    <div class="col-sm-12">
                                        <br><label for="">Date</label>
                                        {{ formDate(__(''), 'invoice_date_created', Carbon\Carbon::today()->format('Y-m-d'), ['style' => 'margin-bottom: 20px;','class' => 'form-control', 'id' => 'invoice_date_created']) }}
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="">REP</label><br>
                                    <input type="text" class="form-control" id="searchrep"
                                        placeholder="REP">
                                </div>
                                <div class="form-group">
                                    <label for="">Customer</label> <br>
                                    <input type="text" class="form-control" id="searchcustomername"
                                        placeholder="{{ __('xinvoice::invoice.labels.customer') }}">
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                    <div class="table-responsive">
                        <table id="bulk_discount_list" class="table table-striped table-bordered no-margin" cellspacing="0"
                            width="100%">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th>Code</th>
                                    <th>Customer</th>
                                    <th>Rep</th>
                                    <th>Date</th>
                                    <th>Remarks</th>
                                    <th>Total Discount</th>
                                    <th>{{ __('common.labels.action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('custom_script')
    <script>
        $(document).ready(function() {

            $('#all_status').tooltip('show');

            var bulk_discount_list = $('#bulk_discount_list').DataTable({
                'iDisplayLength': 15,
                ajax: '{!! route('bulk_discounts.index') !!}',
                order: [
                    [0, "desc"]
                ],
                columns: [{
                        data: 'id',
                        name: 'id',
                        'bVisible': false
                    },
                    {
                        data: 'invoice_code',
                        name: 'invoice_code'
                    },

                    {
                        data: 'company_name',
                        name: 'company_name'
                    },
                    {
                        data: 'rep',
                        name: 'rep'
                    },
                    {
                        data: 'date',
                        name: 'date'
                    },
                    {
                        data: 'remarks',
                        name: 'remarks'
                    },
                    {
                        data: 'total_discount',
                        name: 'total_discount',
                        className: 'dt-body-right'
                    },
                    {
                        data: 'action',
                        name: 'action'
                    },
                ]
            });

            $('#invoice_date_created').on('change', function(){
                bulk_discount_list.column(4)
                    .search(this.value)
                    .draw();
            })

            $('#searchinvoicecode').on('keyup', function() {
                bulk_discount_list.column(1)
                    .search(this.value)
                    .draw();
            });
            $('#searchinvoiceycode').on('keyup', function() {
                bulk_discount_list.column(1)
                    .search(this.value)
                    .draw();
            });
            $('#searchcustomername').on('keyup', function() {
                bulk_discount_list.column(2)
                    .search(this.value)
                    .draw();
            });
            $('#searchrep').on('keyup', function() {
                bulk_discount_list.column(3)
                    .search(this.value)
                    .draw();
            });
            $('input[type=radio][name=invoice_status]').change(function() {
                bulk_discount_list.column(5)
                    .search(this.value)
                    .draw();
            });

            $(document).on('click', '.delete_credit_note', function(e) {
                var data = bulk_discount_list.row($(this).parents('tr')).data();
                var id = data['id'];
                let url = "{{ route('bulk_discounts.delete', ':id') }}";
                url = url.replace(':id', id);
                var parent = $(this).parents('tr');
                var delete_confirm = $.confirm({
                    title: "DELETE DISCOUNT & CREDIT",
                    type: 'red',
                    buttons: {
                        delete: {
                            text: 'Delete',
                            btnClass: 'btn-red',
                            action: function() {

                                e.preventDefault();
                                var params = {

                                };

                                $.ajax({
                                    url: url,
                                    type: 'POST',
                                    dataType: 'JSON',
                                    data: $.param(params),
                                    success: function(response) {
                                        if (response.status == 'error') {
                                            delete_confirm.close();
                                            notification(response);
                                        } else {
                                            delete_confirm.close();
                                            notification(response);
                                            bulk_discount_list.row(parent)
                                                .remove().draw();
                                        }
                                    },
                                    error: function(errors) {}
                                });
                                e.preventDefault();
                                return false;
                            }
                        },
                        close: function() {}
                    }
                });
            });

        });
    </script>
@endsection
