<?php

namespace Pramix\XInvoice\Models;

use App\Scopes\BranchScopes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Pramix\XBranches\Models\BranchesModel;
use Pramix\XCustomer\Models\CustomerModel;
use Spatie\Activitylog\Traits\LogsActivity;

class InvoicePaymentModel extends Model
{
    use LogsActivity;
    protected $table = 'invoice_payments';
    protected $primaryKey = 'id';
    protected $guarded = ['id'];
    protected static $logAttributes = ['id', 'payment_code', 'payment_date', 'payment_method',
    'payment_ref_no', 'payment_remarks', 'payment_amount', 'status'];
    // protected static $recordEvents = ['updated', 'deleted'];
    protected static $logName = 'invoice_payment';

    public static function boot()
    {
        parent::boot();

        static::addGlobalScope(new BranchScopes());

        static::creating(function ($model) {
            $userid = 0;

            if (isset(auth()->user()->id))
                $userid = auth()->user()->id;
            $model->created_by = $userid;
            $model->updated_by = $userid;
            $model->branch_id = BranchesModel::getBranchID();


        });

        static::created(function ($model) {
        });

        static::updating(function ($model) {
            $userid = 0;
            if (isset(auth()->user()->id))
                $userid = auth()->user()->id;
            $model->updated_by = $userid;

        });
        static::deleting(function ($model) {

        });
    }

    public function invoice()
    {
        return $this->hasOne('Pramix\XInvoice\Models\InvoiceModel','id','invoice_id');
    }

    public function rep()
    {
        return $this->belongsTo('Pramix\XUser\Models\User', 'id', 'rep_id');
    }
    public function user()
    {
        return $this->belongsTo('Pramix\XUser\Models\User', 'created_by','id');
    }

    public function customer()
    {
        return $this->belongsTo('Pramix\XCustomer\Models\CustomerModel', 'customer_id','id' );
    }

    public function cheque()
    {
        return $this->belongsTo('Pramix\XPayment\Models\ChequeModel', 'cheque_id', 'id');
    }



}
