@extends('layouts.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row mb-4">
            <div class="col-md-6">
                <h4>{{ __('xcustomer::customer.headings.all_customer_list') }}</h4>
            </div>
            <div class="col-md-6 text-right">
                @can('ADD_CUSTOMER')
                    <a href="{{ url('customer/create') }}" class="btn btn-primary">
                        <i class="fa fa-plus"></i> {{ __('xcustomer::customer.buttons.new_customer') }}
                    </a>
                @endcan
            </div>
        </div>

        <form class="form-inline mb-4" action="{{ route('customer.index') }}">
            <div class="form-group mb-2 mr-2">
                <label for="searchbusinessname" class="sr-only">{{ __('xcustomer::customer.labels.business_name') }}</label>
                <input type="text" name="business_name" value="{{ request('business_name') }}" class="form-control select2" id="searchbusinessname" placeholder="{{ __('xcustomer::customer.labels.business_name') }}">
            </div>
            <div class="form-group mb-2 mr-2">
                <label for="searchfullname" class="sr-only">{{ __('xcustomer::customer.labels.full_name') }}</label>
                <input type="text" name="company_name" value="{{ request('company_name') }}" class="form-control select2" id="searchfullname" placeholder="{{ __('xcustomer::customer.labels.full_name') }}">
            </div>
            <div class="form-group mb-2 mr-2">
                <label for="searchmobile" class="sr-only">{{ __('xcustomer::customer.labels.mobile') }}</label>
                <input type="text" name="mobile" value="{{ request('mobile') }}" class="form-control select2" id="searchmobile" placeholder="{{ __('xcustomer::customer.labels.mobile') }}">
            </div>
            <div class="form-group mb-2 mr-2">
                <label for="rep" class="sr-only">{{ __('Select Rep') }}</label>
                <select name="rep_id" id="rep" class="form-control select2">
                    <option value="">Select Rep</option>
                    @foreach($roles as $role)
                        <option value="{{ $role->id }}" @if(request('rep_id') == $role->id) selected @endif>{{ $role->username }} - {{ $role->fname }}</option>
                    @endforeach
                </select>
            </div>
            <div class="form-group mb-2 mr-2">
                <label for="grade" class="sr-only">{{ __('Select Grade') }}</label>
                <select name="customer_grade" id="grade" class="form-control select2">
                    <option value="">Please Select</option>
                    <option value="A" @if(request('customer_grade') == 'A') selected @endif>A</option>
                    <option value="B" @if(request('customer_grade') == 'B') selected @endif>B</option>
                    <option value="C" @if(request('customer_grade') == 'C') selected @endif>C</option>
                    <option value="D" @if(request('customer_grade') == 'D') selected @endif>D</option>
                </select>
            </div>
            <div class="form-group mb-3">
                <button type="submit" class="btn btn-primary">Submit</button>
                <a href="{{ route('customer.index') }}" class="btn btn-secondary ml-2">Reset</a>
            </div>
        </form>

        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th hidden>ID</th>
                        <th>CUSTOMER CODE</th>
                        <th>FULLNAME</th>
                        <th>MOBILE</th>
                        <th>AREA</th>
                        <th>REP</th>
                        <th>GRADE</th>
                        <th>OUTSTANDING AMOUNT</th>
                        <th>ACTION</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($customers as $customer)
                        <tr>
                            <td hidden>{{ $customer->id }}</td>
                            <td>{{ $customer->business_name }}</td>
                            <td><b>{{ $customer->company_name }}</b></td>
                            <td>{{ $customer->mobile }}</td>
                            <td>{{ $customer->customerPrivateAddress->city->name_en ?? '' }}</td>
                            <td>{{ $customer->rep->username }}</td>
                            <td>{{ $customer->customer_grade }}</td>
                            @php
                                $outstanding_amount = App\Utils\CommonUtil::calculateCustomerInvoiceOutstanding($customer->id);
                            @endphp
                            <td>{{ App\Http\Helper::formatPrice($outstanding_amount) }}</td>
                            <td>
                                @can('SHOW_ATTECH_FILES')
                                    <a class="btn btn-success btn-xs" href="{{ route('file-attech', $customer->id) }}" title="View Files"><i class="fa fa-file"></i></a>
                                @endcan

                                @can('BLOCK_CUSTOMER')
                                @php
                                    $route = $customer->block_status == 'Blocked' ? route('unblock.customer', $customer->id) : route('block.customer', $customer->id);
                                    $icon = $customer->block_status == 'Blocked' ? 'fa-check' : 'fa-ban';
                                    $title = $customer->block_status == 'Blocked' ? 'Unblock Customer' : 'Block Customer';
                                    $buttonClass = $customer->block_status == 'Blocked' ? 'btn-danger' : 'btn-warning';  
                                @endphp
                                <a class="btn {{ $buttonClass }} btn-xs" href="{{ $route }}" title="{{ $title }}">
                                    <i class="fa {{ $icon }}"></i>
                                </a>
                            @endcan
                            

                                @can('EDIT_CUSTOMER')
                                    <a class="btn btn-info btn-xs" href="{{ url('/customer/' . $customer->id . '/edit') }}" title="Edit Customer"><i class="fa fa-pencil"></i></a>
                                @endcan

                                @can('DELETE_CUSTOMER')
                                    <button class="delete_customer btn btn-danger btn-xs" data-id="{{ $customer->id }}" title="Delete Customer"><i class="fa fa-trash-o"></i></button>
                                @endcan
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-end">
            {{ $customers->appends(request()->input())->links() }} 
        </div>
    </div>


    
@endsection

@section('include_js')
<script>
    jQuery(document).ready(function($) {
        $('.select2').select2();

        $(document).on('click', '.delete_customer', function() {
            var customerId = $(this).data('id');
            if (confirm('Are you sure you want to delete this customer?')) {
                $.ajax({
                    url: '/customer/' + customerId,
                    type: 'DELETE',
                    success: function(response) {
                        location.reload(); 
                    },
                    error: function(xhr, status, error) {
                        alert('An error occurred while deleting the customer.');
                    }
                });
            }
        });
    });
    
</script>
@endsection
