<?php

use Illuminate\Database\Seeder;
use Pramix\XPayment\Models\ChequeModel;
use Pramix\XInvoice\Models\InvoiceModel;
use App\Invoice;
use App\BulkDiscountModel;
use Pramix\XInvoice\Models\InvoicePaymentModel;
use App\ChequeReturnPayment;
use Pramix\XInvoice\Models\InvoiceReturnModel;
use Carbon\Carbon;

class ReferenceTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {

        $data = [
            [
                'id' => 1,
                'no' => 584,
                'type'=>'payment',
                'sub_type'=>10,
                'prefix'=>'IP',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 2,
                'no' => 771,
                'type'=>'payment',
                'sub_type'=>35,
                'prefix'=>'BP',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 3,
                'no' => 6,
                'type'=>'cheque',
                'sub_type'=>10,
                'prefix'=>'CQ',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 4,
                'no' => 1,
                'type'=>'cheque',
                'sub_type'=>35,
                'prefix'=>'BQ',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 5,
                'no' => 96,
                'type'=>'credit_note',
                'sub_type'=>10,
                'prefix'=>'IG',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 6,
                'no' => 89,
                'type'=>'credit_note',
                'sub_type'=>35,
                'prefix'=>'BG',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 7,
                'no' => 339,
                'type'=>'discount',
                'sub_type'=>10,
                'prefix'=>'ID',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 8,
                'no' => 519,
                'type'=>'discount',
                'sub_type'=>35,
                'prefix'=>'BD',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 9,
                'no' => 1097,
                'type'=>'invoice',
                'sub_type'=>10,
                'prefix'=>'IN',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 10,
                'no' => 1432,
                'type'=>'invoice',
                'sub_type'=>35,
                'prefix'=>'BL',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 11,
                'no' => 13,
                'type'=>'cheque_return',
                'sub_type'=>10,
                'prefix'=>'PQ',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
            [
                'id' => 12,
                'no' => 3,
                'type'=>'cheque_return',
                'sub_type'=>35,
                'prefix'=>'QP',
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),

            ],
        ];
        \DB::table('references')->insert($data);
    }
}
