<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChequeReturnPaymentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cheque_return_payments', function (Blueprint $table) {
            $table->id();
            $table->date('payment_date');
            $table->date('cheque_date');
            $table->char('payment_method');
            $table->string('payment_code')->nullable();
            $table->string('payment_ref_no')->nullable();
            $table->string('payment_remarks')->nullable();
            $table->double('total_payment_amount');
            $table->integer('created_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cheque_return_payments');
    }
}
