<?php

namespace App\Utils;

use App\City;
use App\Customer;
use App\Grn;
use App\Invoice;
use App\InvoicePayment;
use App\InvoiceProduct;
use App\InvoiceReturn;
use Pramix\XInvoice\Models\InvoiceReturnModel;
use App\ChequeReturnPaymentHasCheque;
use App\ChequeReturnPayment;
use App\Product;
use App\BulkDiscountModel;
use App\BulkDiscountInvoiceModel;
use Carbon\Carbon;
use DateTime;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Pramix\XCustomer\Models\CustomerModel;
use Pramix\XPayment\Models\ChequeModel;
use Pramix\XProduct\Models\ProductCategoriesModel;
use Pramix\XReports\Models\ReportsModel;
use Pramix\XUser\Models\User;
use Pramix\XInvoice\Models\InvoiceModel;


class ReportUtil
{
    public function salesReport($filters)
    {
        $customers = Customer::with(['invoices', 'address', 'rep'])
            ->where('customer.status', 'A');
        $user = Auth::user();
        if ($user->username == 'user35' || $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $customers->where('salesReport', '35');
        }
        $from_date = null;
        $end_date = null;
        $city = null;
        $rep = null;
        $item = null;
        $customer_name = null;
        $customer_code = null;

        // dd($customers->toSql());
        if (!empty($filters['city_id'])) {
            $city_id = $filters['city_id'];
            $customers->whereHas('address', function ($query) use ($city_id) {
                $query->where('city_id', $city_id);
            });
            $city = City::find($city_id)->name_en;
        }
        if (!empty($filters['customer_id'])) {
            $customer_id = $filters['customer_id'];
            $customers->whereHas('invoices', function ($query) use ($customer_id) {
                $query->where('customer_id', $customer_id);
            });
            $customer_name = Customer::find($customer_id)->company_name;
            $customer_code = Customer::find($customer_id)->business_name;
        }
        if (!empty($filters['rep_id'])) {
            $rep_id = $filters['rep_id'];
            $customers->where('rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        if (!empty($filters['invoice_rep'])) {
            $rep_id = $filters['invoice_rep'];
            $customers->whereHas('invoices', function ($query) use ($rep_id) {
                $query->where('rep_id', $rep_id);
            });
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        $customers = $customers->orderBy('business_name')->get();

        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            //* manual filtered
            foreach ($customers as $customer) {
                $customer_invoice_array = [];
                foreach ($customer->invoices as $invoice) {
                    if ($invoice->status == 'I') {
                        $is_in_date_range = Carbon::parse($invoice->invoice_date)->between($from_date, $end_date);
                        if ($is_in_date_range) {
                            array_push($customer_invoice_array, $invoice);
                        }
                    }
                }
                $customer->invoices = collect($customer_invoice_array)->sortBy('invoice_date');
            }
        }

        $parameters = array(
            'customers' => $customers,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'city' => $city,
            'rep' => $rep,
            'item' => $item,
            'customer_name' => $customer_name,
            'customer_code' => $customer_code
        );
        $pdf = \PDF::loadView('xreports::sales.sales_report.sales', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'sales_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }

    public function salesReportItemWise($filters)
    {
        // dd($filters);
        $invoice_items = InvoiceProduct::with(['invoice', 'invoice.customer', 'invoice.rep'])->where('status', true);


        $invoice_items->whereHas('invoice', function ($query) {
            $query->where('status', 'I');
        });

        $from_date = null;
        $end_date = null;
        $city = null;
        $rep = null;
        $item = null;
        $customer = null;

        //        $user = Auth::user();
//        if ($user->username == 'user35') {
//            $invoice_items->where('invoice.user_type', '35');
//        }

        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            $invoice_items->whereHas('invoice', function ($query) use ($from_date, $end_date) {
                $query->whereBetween('invoice.invoice_date', [$from_date, $end_date]);
            });
            // dd($invoice_items->get());
        }
        if (!empty($filters['city_id'])) {
            $city_id = $filters['city_id'];
            $invoice_items->whereHas('invoice.customer', function ($query) use ($city_id) {
                $query->where('area_id', $city_id);
            });

            $city = City::find($city_id)->name_en;
        }
        if (!empty($filters['customer_id'])) {
            $customer_id = $filters['customer_id'];
            $invoice_items->whereHas('invoice', function ($query) use ($customer_id) {
                $query->where('customer_id', $customer_id);
            });
            $customer = Customer::find($customer_id)->company_name;

        }
        if (!empty($filters['invoice_rep'])) {
            $rep_id = $filters['invoice_rep'];
            $invoice_items->whereHas('invoice', function ($query) use ($rep_id) {
                $query->where('rep_id', $rep_id);
            });
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        if (!empty($filters['rep_id'])) {
            $rep_id = $filters['rep_id'];
            $invoice_items->whereHas('invoice.customer', function ($query) use ($rep_id) {
                $query->where('customer.rep_id', $rep_id);
            });
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        if (!empty($filters['product_id'])) {
            $product_id = $filters['product_id'];
            $invoice_items->where('product_id', $product_id);
            $item = Product::find($product_id)->stock_id;
            // dd($item);
        }
        $invoice_items = $invoice_items->get();
        // dd($invoice_items->get());
        $parameters = array(
            'invoice_items' => $invoice_items,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'city' => $city,
            'rep' => $rep,
            'item' => $item,
            'customer' => $customer
        );
        // dd($parameters);
        $pdf = \PDF::loadView('xreports::sales.sales_report_item_wise.sales_item_wise', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'sales_report_item_wise_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }


    public function goodsReturnReport($filters)
    {

        $customers = Customer::join('invoice_return', 'invoice_return.customer_id', '=', 'customer.id')
            ->join('invoice_return_product', 'invoice_return_product.invoice_return_id', '=', 'invoice_return.id')
            ->join('product', 'product.id', '=', 'invoice_return_product.product_id')
            ->select(
                'customer.company_name AS customer_name',
                'customer.status AS customer_status',
                'invoice_return.status AS invoice_return_status',
                'invoice_return.invoice_return_date AS invoice_return_date',
                'invoice_return.invoice_return_code AS invoice_return_code',
                'invoice_return_product.id AS invoice_return_product_id',
                'invoice_return_product.qty AS invoice_return_product_qty',
                'product.stock_id AS product_stock_id',
                'product.description AS product_description',
                'product.item_code AS product_item_code',

            )
            ->where('customer.status', 'A')
            ->where('invoice_return.invoice_return_code', '!=', '')
            ->where('invoice_return.status', 'A')
            ->groupBy('invoice_return_product.id') // Group by product_id
            ->selectRaw('SUM(pramix_invoice_return_product.qty) AS total_qty');

        $user = Auth::user();
        if ($user->username == 'user35' || $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $customers->where('customer.invoice_type', '35');
        }

        $rep = '';

        // date filter
        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');

            $customers->whereBetween('invoice_return.invoice_return_date', [$from_date, $end_date]);
        }

        //  customer filter
        if (!empty($filters['customer_id'])) {
            $customer_id = $filters['customer_id'];
            $customers->where('invoice_return.customer_id', $customer_id);
            $customer = Customer::find($customer_id)->company_name;
        }

        //customer rep
        if (!empty($filters['rep_id'])) {
            $rep_id = $filters['rep_id'];
            $customers->where('customer.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }

        //invoice rep
        if (!empty($filters['invoice_rep'])) {
            $rep_id = $filters['invoice_rep'];
            $customers->where('invoice.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }

        //product filter
        if (!empty($filters['product_id'])) {
            $product_id = $filters['product_id'];
            $customers->where('invoice_return_product.product_id', $product_id);
            $item = Product::find($product_id)->item_code;
        }

        $customers = $customers->get();
        $sorted_customers = $customers->sortBy('customer_name')->values()->all();

        $parameters = array(
            'customers' => $sorted_customers,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'rep' => $rep,
        );

        $pdf = \PDF::loadView('xreports::sales.goods_return_report.goods_return', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'goods_return_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/grn');
        return $path;
    }


    public function grnReport($filters)
    {
        $grns = Grn::join('grn_product', 'grn_product.grn_id', '=', 'grn.id')
            ->join('product', 'grn_product.product_id', '=', 'product.id')
            ->select(
                'grn.id',
                'grn.grn_code',
                'grn.grn_date',
                'grn_product.description',
                'grn_product.delivered_qty',
                'grn_product.product_id',
                'product.category_id'
            )
            ->where('grn.status', 'A');

        $from_date = null;
        $end_date = null;
        $item = null;
        $category = null;
        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            $grns->whereBetween('grn_date', [$from_date, $end_date]);
        }
        if (!empty($filters['category_id'])) {
            $category_id = $filters['category_id'];
            $grns->where('category_id', $category_id);
            $category = ProductCategoriesModel::find($category_id)->description;
        }
        if (!empty($filters['product_id'])) {
            $product_id = $filters['product_id'];
            $grns->where('product_id', $product_id);
            $item = Product::find($product_id)->item_code;
        }
        $grns = $grns->get();
        dd($grns);
        $parameters = array(
            'grns' => $grns,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'item' => $item,
            'category' => $category
        );
        $pdf = \PDF::loadView('xreports::purchasing.grn_report.grn', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'grn_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/grn');
        return $path;
    }

    public function inventoryReport($filters)
    {
        $inventories = Product::where('status', 'A')->where('qty_on_hand', '>', 0)
            ->select(
            'id',
            'stock_id',
            'item_code',
            'description',
            'qty_on_hand',
            'price',
            DB::raw('(qty_on_hand * price) AS qty_value')
        );

        $item = null;
        if (!empty($filters['product_id'])) {
            $product_id = $filters['product_id'];
            $inventories->where('id', $product_id);
            $item = Product::find($product_id)->item_code;
        }
        $inventories = $inventories->get();
        $parameters = array(
            'inventories' => $inventories,
            'item' => $item,
        );
        $pdf = \PDF::loadView('xreports::inventory.inventory_report.inventory', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'inventory_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/inventory');
        return $path;
    }

    public function customerTransactionHistoryReport($filters)
    {

        $from_date = null;
        $end_date = null;
        $city = null;
        $rep = null;
        $customer_name = null;

        //    $customers = Customer::with(['area', 'invoices', 'invoices.rep', 'invoices.invoice_payments',
        //        'invoices.invoice_returns' => function ($query) {
        //            $query->whereNull('deleted_at');
        //        },
        //        'invoices.bulk_discount_invoices'])
        //        ->where('status', 'A')
        //        ->whereHas('invoices.invoice_returns', function ($query) {
        //            $query->whereNull('deleted_at');
        //        });


        // $customers = Customer::all();

        // $customers = Customer::with(['area', 'invoices'=> function($query){
        //         $query->where('invoice_code','!=', '');
        // }, 'invoices.rep', 'invoices.invoice_payments',
        //     'invoices.invoice_returns' => function ($query) {
        //         $query->whereNull('deleted_at');
        //     },
        //     'invoices.bulk_discount_invoices'])
        //     ->where('status', 'A')
        //     ->groupBy('invoices.invoice_code');

        // $customers = Customer::with(['area', 'invoices' => function ($query) {
        //     $query->where('invoice_code', '!=', '');
        // }, 'invoices.rep', 'invoices.invoice_payments',
        // 'invoices.invoice_returns' => function ($query) {
        //     $query->whereNull('deleted_at');
        // },
        // 'invoices.bulk_discount_invoices'])
        // ->where('status', 'A')
        // ->groupBy('invoice.invoice_code') // Use the primary key of the `invoices` table (e.g., 'id')
        // ->havingRaw('COUNT(invoices.id) > 0'); // Ensure there are related invoices


        $customers = Customer::where('status', 'A');

        $customer_id = $filters['customer_id'];
        if ($customer_id) {
            $customers->where('id', $customer_id);
        }

        $user = Auth::user();
        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $customers->where('invoice_type', '35');
        }

        $rep_id = $filters['rep_id'];
        if ($rep_id) {
            $customers->where('rep_id', $rep_id);
        }

        $customers = $customers->get();

        $from_date = '';
        $end_date = '';
        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
        }

        $reportData = array();

        foreach ($customers as $customer) {

            $dataObject = array(
                'company_name' => $customer->business_name . '-' . $customer->company_name,
                'invoices' => array() // Start with an empty invoices array
            );

            $invoices = Invoice::where('customer_id', $customer->id)->where('status', 'I');

            $invoice_rep_id = $filters['invoice_rep'];
            if ($invoice_rep_id) {
                $invoices->where('rep_id', $invoice_rep_id);
            }

            if ($from_date && $end_date) {
                $invoices->whereBetween('invoice_date', [$from_date, $end_date]);
            }

            if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
                $invoices->where('invoice_type', '35');
            }


            $invoices = $invoices->orderBy('id')->get();



            foreach ($invoices as $item) {
                $invoice_total = $item->total;
                $balance = $item->total;
                $data = [
                    'refNo' => $item->invoice_code,
                    'date' => $item->invoice_date,
                    'description' => 'Sale',
                    'remarks' => $item->remarks,
                    'credit' => number_format($invoice_total, 2),
                    'debit' => '0',
                    'balance' => number_format($invoice_total, 2),
                ];

                $dataObject['invoices'][] = $data;

                $payments = InvoicePayment::where('invoice_id', $item->id)->where('status', 1)->orderBy('id')
                    ->whereNull('deleted_at')->get();
                foreach ($payments as $payment) {
                    $paidAmount = $payment->payment_amount;
                    $balance = $balance - $paidAmount;
                    $paymentData = [
                        'refNo' => $payment->payment_code,
                        'date' => $payment->payment_date,
                        'description' => 'Payment',
                        'remarks' => $payment->payment_remarks,
                        'credit' => '0',
                        'debit' => number_format($paidAmount, 2),
                        'balance' => number_format($balance, 2),
                    ];

                    $dataObject['invoices'][] = $paymentData;
                }

                $creditNotes = InvoiceReturn::where('invoice_return_code', '!=', '')->whereNull('deleted_at')
                    ->where('deduct_invoice_id', $item->id)->where('total', '!=', 0)->orderBy('id')->get();

                foreach ($creditNotes as $notes) {
                    $returnAmount = $notes->total;
                    $balance = $balance - $returnAmount;
                    $returnData = [
                        'refNo' => $notes->invoice_return_code,
                        'date' => $notes->invoice_return_date,
                        'description' => 'Return',
                        'remarks' => $notes->remarks,
                        'credit' => '0',
                        'debit' => number_format($returnAmount, 2),
                        'balance' => number_format($balance, 2),
                    ];
                    $dataObject['invoices'][] = $returnData;
                }

                $discounts = BulkDiscountInvoiceModel::where('invoice_id', $item->id)->whereNull('deleted_at')->orderBy('id')->get();

                foreach ($discounts as $discount) {
                    $discountAmount = $discount->discount;
                    $balance = $balance - $discountAmount;
                    $discountData = [
                        'refNo' => $discount->bulk_invoice->invoice_code,
                        'date' => Carbon::parse($discount->bulk_invoice->date)->format('Y-m-d'),
                        'description' => 'Discount',
                        'remarks' => $discount->bulk_invoice->remarks,
                        'credit' => '0',
                        'debit' => number_format($discountAmount, 2),
                        'balance' => number_format($balance, 2),
                    ];
                    $dataObject['invoices'][] = $discountData;
                }
            }

            $reportData[] = $dataObject;

        }

        $parameters = array(
            'customers' => $reportData,
            'from_date' => $from_date,
            'end_date' => $end_date,
        );

        $pdf = \PDF::loadView('xreports::sales.customer_transaction_history_report.customer_transaction_history', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'customer_transaction_history_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }

    public function chequeReturnOutstandingPeriodWiseReport($filter_details)
    {
        $customer = CustomerModel::find($filter_details['customer_id']);
        $returned_cheques = ChequeModel::where('status', 2);
        $user = Auth::user();
        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $returned_cheques->where('user_type', '35');
        }
        if ($filter_details['customer_id'] != '')
            $returned_cheques->where('customer_id', $filter_details['customer_id']);

        if ($filter_details['rep'] != '') {
            $returned_cheques->with('customer')->whereHas('customer', function ($query) use ($filter_details) {
                $query->where('rep_id', $filter_details['rep']);
            });
        }

        if ($filter_details['invoice_rep'] != '') {
            $returned_cheques->whereHas('invoice_payment.invoice', function ($query) use ($filter_details) {
                $query->where('rep_id', $filter_details['invoice_rep']);
            });
        }

        $returned_cheques = $returned_cheques->orderBy('cheque_date')->get();

        foreach ($returned_cheques as $returned_cheque) {
            $total_cheque_return_amount = 0;
            $less_30_days = 0;
            $between_31_60_days = 0;
            $between_61_90_days = 0;
            $over_91 = 0;

            $total_cheque_return_amount += $returned_cheque->payment_amount;
            $credit = ChequeReturnPaymentHasCheque::where('cheque_id', $returned_cheque->id)->sum('payment_amount');
            $balance = $total_cheque_return_amount - $credit;

            $less_30_days += ChequeReturnPaymentHasCheque::where('cheque_id', $returned_cheque->id)
                ->whereBetween('created_at', [Carbon::now()->subDays(30), Carbon::now()])
                ->whereNotNull('cheque_id')
                ->sum('payment_amount');

            $between_31_60_days += ChequeReturnPaymentHasCheque::where('cheque_id', $returned_cheque->id)
                ->whereBetween('created_at', [Carbon::now()->subDays(60), Carbon::now()->subDays(31)])
                ->whereNotNull('cheque_id')
                ->sum('payment_amount');


            $between_61_90_days += ChequeReturnPaymentHasCheque::where('cheque_id', $returned_cheque->id)
                ->whereBetween('created_at', [Carbon::now()->subDays(90), Carbon::now()->subDays(61)])
                ->whereNotNull('cheque_id')
                ->sum('payment_amount');


            $over_91 += ChequeReturnPaymentHasCheque::where('cheque_id', $returned_cheque->id)
                ->where('created_at', '<', Carbon::now()->subDays(90))
                ->whereNotNull('cheque_id')
                ->sum('payment_amount');


            $returned_cheque['total_cheque_return_amount'] = $balance;
            $returned_cheque['less_30_days'] = $less_30_days;
            $returned_cheque['between_31_60_days'] = $between_31_60_days;
            $returned_cheque['between_61_90_days'] = $between_61_90_days;
            $returned_cheque['over_91'] = $over_91;


        }

        $pdf = \PDF::loadView('xreports::sales.cheque_return_outstanding_period_wise.cheque_return_outstanding_period_wise_report', array('returned_cheques' => $returned_cheques))
            ->setPaper('letter', 'portrait');
        $file_name = 'cheque_return_outstanding_period_wise_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }

    public function collectionCommissionReport($filters)
    {
        $from_date = null;
        $end_date = null;
        $rep = null;
        $period = 165;
        if (!empty($filters['period'])) {
            $period = $filters['period'];
        }
        $invoices = Invoice::leftJoin('customer', 'invoice.customer_id', '=', 'customer.id')
            ->leftJoin('cities', 'customer.area_id', '=', 'cities.id')
            ->leftJoin('invoice_payments', 'invoice_payments.invoice_id', '=', 'invoice.id')
            ->select(
                'invoice.id',
                'invoice.invoice_code',
                'invoice.invoice_date',
                'invoice.rep_id',
                'customer.company_name',
                'cities.name_en',
                'invoice_payments.payment_code',
                'invoice_payments.payment_date',
                'invoice_payments.cheque_date',
                DB::raw('DATEDIFF(pramix_invoice_payments.cheque_date, pramix_invoice.invoice_date) AS days'),
                DB::raw("SUM(CASE
                                WHEN
                                    $period >= DATEDIFF(pramix_invoice_payments.cheque_date, pramix_invoice.invoice_date)
                                THEN
                                    pramix_invoice_payments.payment_amount
                                ELSE 0
                            END) AS collection"),
            )
            ->where('invoice.status', 'I')
            ->where('invoice_payments.status', '1')
            ->orderBy('invoice.invoice_date', 'asc')
            ->groupBy('invoice.id');

        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            $invoices->whereBetween('invoice.invoice_date', [$from_date, $end_date]);
        }
        if (!empty($filters['rep_id'])) {
            $rep_id = $filters['rep_id'];
            $invoices->where('invoice.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        $invoices = $invoices->get();

        $parameters = array(
            'invoices' => $invoices,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'rep' => $rep,
        );
        $pdf = \PDF::loadView('xreports::commission.collection_commission', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'collection_commission_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/commission');
        return $path;
    }

    public function directSaleReport($filters)
    {
        // dd('inside report util');
        // HAVE ISSUE DATA NOT COMING
        $from_date = null;
        $end_date = null;
        $rep = null;
        $direct_sales = Invoice::leftJoin('customer', 'invoice.customer_id', '=', 'customer.id')
            ->select(
                'invoice.*',
                'customer.business_name'
            )
            ->where('invoice.status', 'Q')
            ->orderBy('customer.business_name', 'asc');

        $user = Auth::user();
        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $direct_sales->where('user_type', '35');
        }

        if (!empty($filter_details['invoice_rep'])) {
            $rep_id = $filter_details['invoice_rep'];
            $direct_sales->where('invoice.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }

        if (!empty($filters['rep_id'])) {
            $rep_id = $filters['rep_id'];
            $direct_sales->where('customer.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }

        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            $direct_sales->whereBetween('invoice.invoice_date', [$from_date, $end_date]);
        }

        dd($direct_sales->get());
        die();
        // $direct_sales = $direct_sales->get();
        $parameters = array(
            'invoices' => $direct_sales,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'rep' => $rep,
        );
        $pdf = \PDF::loadView('xreports::sales.direct_sale_report.direct_sale_report', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'direct_sales_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }

    public function generateSalesReportWise($filters)
    {
        $from_date = null;
        $end_date = null;
        $rep = null;
        $report_type = $filters['report_type'];


        $direct_sale_invoices = Invoice::join('customer', 'customer.id', '=', 'invoice.customer_id')
            ->select(
                'invoice.id',
                'invoice.invoice_code',
                'invoice.rep_id',
                'invoice.invoice_date',
                'invoice.user_type',
                'invoice.returned_amount',
                'invoice.balance',
                'invoice.total',
                'customer.rep_id as customer_rep_id'
            )->where('invoice.status', 'I');


        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');

            $direct_sale_invoices->whereBetween('invoice_date', [$from_date, $end_date]);
        }
        $user = Auth::user();
        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $invoices->where('user_type', '35');
            $direct_sale_invoices->where('user_type', '35');
        }
        if (!empty($filters['invoice_rep'])) {
            $rep_id = $filters['invoice_rep'];

            $direct_sale_invoices->where('invoice.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }

        if (!empty($filters['rep_id'])) {
            $rep_id = $filters['rep_id'];
            $direct_sale_invoices->where('customer.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }

        $direct_sale_invoices = $direct_sale_invoices->get();

        $direct_sale_parameters = array(
            'invoices' => $direct_sale_invoices,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'rep' => $rep,
        );


        if ($report_type == 'invoice_wise') {
            $pdf = \PDF::loadView('xreports::sales.direct_sale_report.direct_sale_report', $direct_sale_parameters)
                ->setPaper('letter', 'portrait');
            $file_name = 'direct_sales_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        }

        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }

    public function generateDailySalesSummaryReport($filters)
    {
        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            $dateRangeArray = [];

            $currentDate = Carbon::parse($from_date);
            $endDate = Carbon::parse($end_date);

            while ($currentDate <= $endDate) {
                $dateRangeArray[] = $currentDate->format('Y-m-d');
                $currentDate->addDay();
            }
        }

        $invoice_rep_id = '';
        $customer_rep_id = '';

        if (!empty($filters['invoice_rep'])) {
            $invoice_rep_id = $filters['invoice_rep'];
        }
        if (!empty($filters['rep_id'])) {
            $customer_rep_id = $filters['rep_id'];
        }

        $user = Auth::user();
        $rep = '';
        $results = [];

        foreach ($dateRangeArray as $date) {

            if (!empty($invoice_rep_id)) {
                if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->where('user_type', '35')
                        ->where('rep_id', $invoice_rep_id)->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('deduct_invoice_id', '!=', 0)
                        ->where('invoice_return_date', $date)
                        ->where('customer_type', '35')
                        ->whereHas('customer', function ($query) use ($invoice_rep_id) {
                            $query->where('rep_id', $invoice_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_type', '35')
                        ->whereHas('customer', function ($query) use ($invoice_rep_id) {
                            $query->where('rep_id', $invoice_rep_id);
                        })
                        ->sum('total_discount');
                } else {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->where('rep_id', $invoice_rep_id)->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('deduct_invoice_id', '!=', 0)
                        ->where('invoice_return_date', $date)
                        ->whereHas('customer', function ($query) use ($invoice_rep_id) {
                            $query->where('rep_id', $invoice_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->whereHas('customer', function ($query) use ($invoice_rep_id) {
                            $query->where('rep_id', $invoice_rep_id);
                        })
                        ->sum('total_discount');
                }

                $rep_user = User::find($invoice_rep_id);
                $rep = $rep_user->fname . ' ' . $rep_user->lname;
            } else if (!empty($customer_rep_id)) {

                if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->where('user_type', '35')
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('invoice_return_date', $date)
                        ->where('deduct_invoice_id', '!=', 0)
                        ->where('customer_type', '35')
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_type', '35')
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total_discount');
                } else {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('deduct_invoice_id', '!=', 0)
                        ->where('invoice_return_date', $date)
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total_discount');
                }

                $rep_user = User::find($customer_rep_id);
                $rep = $rep_user->fname . ' ' . $rep_user->lname;
            } else {
                if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->where('user_type', '35')
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('deduct_invoice_id', '!=', 0)
                        ->where('invoice_return_date', $date)
                        ->where('customer_type', '35')
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_type', '35')
                        ->sum('total_discount');
                } else {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                    ->where('deduct_invoice_id', '!=', 0)
                    ->where('invoice_return_date', $date)->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)->sum('total_discount');
                }
            }

            $results[] = [
                'date' => $date,
                'invoice_total' => $invoice_total,
                'credit_notes_total' => $credit_notes_total,
                'discount_total' => $discount_total
            ];
        }

        $parameters = array(
            'invoices' => $results,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'rep' => $rep,
        );

        $pdf = \PDF::loadView('xreports::sales.daily_sales_summary.daily_sales_summary_report', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'daily_sales_summary_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;

    }

    public function salesCommissionReportGenerate($filters, $reportName)
    {
        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            $dateRangeArray = [];

            $currentDate = Carbon::parse($from_date);
            $endDate = Carbon::parse($end_date);

            while ($currentDate <= $endDate) {
                $dateRangeArray[] = $currentDate->format('Y-m-d');
                $currentDate->addDay();
            }
        }

        $customer_id = '';
        $customer_rep_id = '';

        if (!empty($filters['customer_id'])) {
            $customer_id = $filters['customer_id'];
        }
        if (!empty($filters['rep_id'])) {
            $customer_rep_id = $filters['rep_id'];
        }

        $user = Auth::user();
        $rep = '';
        $results = [];

        foreach ($dateRangeArray as $date) {

            if (!empty($customer_id)) {
                if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->where('user_type', '35')
                        ->where('customer_id', $customer_id)
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('invoice_return_date', $date)
                        ->whereNull('parent_id')
                        ->where('customer_type', '35')
                        ->where('customer_id', $customer_id)
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_type', '35')
                        ->where('customer_id', $customer_id)
                        ->sum('total_discount');
                } else {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->where('customer_id', $customer_id)
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->whereNull('parent_id')
                        ->where('invoice_return_date', $date)
                        ->where('customer_id', $customer_id)
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_id', $customer_id)
                        ->sum('total_discount');
                }
                // $rep = $user->fname . ' ' . $user->lname;

            } else if (!empty($customer_rep_id)) {
                // here the customer_rep_id variable is used to filter using invoice rep id. avoid confusions
                if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->where('user_type', '35')
                        ->where('rep_id', $customer_rep_id)
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->whereNull('parent_id')
                        ->where('invoice_return_date', $date)
                        ->where('customer_type', '35')
                        ->whereHas('invoice', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_type', '35')
                        ->whereHas('bulk_discount_invoices', function ($query) use ($customer_rep_id) {
                            $query->whereHas('invoice', function ($subquery) use ($customer_rep_id) {
                                $subquery->where('rep_id', $customer_rep_id);
                            });
                        })
                        ->sum('total_discount');
                } else {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->where('rep_id', $customer_rep_id)
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->whereNull('parent_id')
                        ->where('invoice_return_date', $date)
                        ->whereHas('invoice', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->whereHas('bulk_discount_invoices', function ($query) use ($customer_rep_id) {
                            $query->whereHas('invoice', function ($subquery) use ($customer_rep_id) {
                                $subquery->where('rep_id', $customer_rep_id);
                            });
                        })
                        ->sum('total_discount');
                }

                $rep_user = User::find($customer_rep_id);
                $rep = $rep_user->fname . ' ' . $rep_user->lname;

            } else {
                if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->where('user_type', '35')
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->whereNull('parent_id')
                        ->where('invoice_return_date', $date)
                        ->where('customer_type', '35')
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_type', '35')
                        ->sum('total_discount');
                } else {

                    $invoice_total = InvoiceModel::where('invoice_date', $date)
                        ->where('invoice_code', '!=', '')
                        ->where('status', 'I')
                        ->sum('total');
                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                    ->whereNull('parent_id')
                    ->where('invoice_return_date', $date)->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)->sum('total_discount');
                }
            }

            $results[] = [
                'date' => $date,
                'invoice_total' => $invoice_total,
                'credit_notes_total' => $credit_notes_total,
                'discount_total' => $discount_total
            ];
        }

        $parameters = array(
            'invoices' => $results,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'rep' => $rep,
            'reportName' => $reportName
        );

        $pdf = \PDF::loadView('xreports::commission.sales_commission.sales_commission_report', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'sales_commission_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales/commission');
        return $path;

    }



    public function generateDailyGoodsReturnSummaryReport($filters)
    {
        $user = Auth::user();
        $rep = '';
        if (!empty($filters['date_range'])) {

            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            $dateRangeArray = [];


            $currentDate = Carbon::parse($from_date);
            $endDate = Carbon::parse($end_date);

            while ($currentDate <= $endDate) {
                $dateRangeArray[] = $currentDate->format('Y-m-d');
                $currentDate->addDay();
            }

        }

        foreach ($dateRangeArray as $date) {

            if (!empty($invoice_rep_id)) {

                if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {

                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('status', '=', 'A')
                        ->where('parent_id', NULL)
                        ->where('invoice_return_date', $date)
                        ->where('customer_type', '35')
                        ->whereHas('customer', function ($query) use ($invoice_rep_id) {
                            $query->where('rep_id', $invoice_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_type', '35')
                        ->whereHas('customer', function ($query) use ($invoice_rep_id) {
                            $query->where('rep_id', $invoice_rep_id);
                        })
                        ->sum('total_discount');
                } else {

                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('status', '=', 'A')
                        ->where('parent_id', NULL)
                        ->where('invoice_return_date', $date)
                        ->whereHas('customer', function ($query) use ($invoice_rep_id) {
                            $query->where('rep_id', $invoice_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->whereHas('customer', function ($query) use ($invoice_rep_id) {
                            $query->where('rep_id', $invoice_rep_id);
                        })
                        ->sum('total_discount');
                }
                $rep = $user->fname . ' ' . $user->lname;
            } else if (!empty($customer_rep_id)) {

                if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {

                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('invoice_return_date', $date)
                        ->where('status', '=', 'A')
                        ->where('parent_id', NULL)
                        ->where('customer_type', '35')
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_type', '35')
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total_discount');
                } else {

                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('invoice_return_date', $date)
                        ->where('status', '=', 'A')
                        ->where('parent_id', NULL)
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->whereHas('customer', function ($query) use ($customer_rep_id) {
                            $query->where('rep_id', $customer_rep_id);
                        })
                        ->sum('total_discount');
                }
                $rep = $user->fname . ' ' . $user->lname;
            } else {
                if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {


                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')
                        ->where('invoice_return_date', $date)
                        ->where('status', '=', 'A')
                        ->where('parent_id', NULL)
                        ->where('customer_type', '35')
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)
                        ->where('customer_type', '35')
                        ->sum('total_discount');

                } else {

                    $credit_notes_total = InvoiceReturn::where('invoice_return_code', '!=', '')->where('invoice_return_date', $date)
                        ->where('status', '=', 'A')
                        ->where('parent_id', NULL)
                        ->sum('total');
                    $discount_total = BulkDiscountModel::whereRaw('DATE(date) = ?', $date)->sum('total_discount');
                }
            }

            $results[] = [
                'date' => $date,
                'credit_notes_total' => $credit_notes_total,
                'discount_total' => $discount_total
            ];
        }

        $parameters = array(
            'invoice_returns' => $results,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'rep' => $rep
        );

        $pdf = \PDF::loadView('xreports::sales.daily_goods_return_summary.daily_goods_return_summary_report', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'daily_goods_return_summary_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales');
        return $path;
    }

    public function generateGoodReturnWiseSummaryReport($filters)
    {

        $invoice_returns = DB::table('invoice_return')
            ->join('invoice_return_product', 'invoice_return_product.invoice_return_id', '=', 'invoice_return.id')
            ->join('customer', 'customer.id', '=', 'invoice_return.customer_id')
            ->join('invoice', 'invoice.id', '=', 'invoice_return.invoice_id')
            ->select(
                'invoice_return.invoice_return_code',
                'invoice_return_product.description',
                DB::raw('SUM(pramix_invoice_return_product.qty) AS total_qty')
            )
            ->where('invoice_return.invoice_return_code', '!=', '')
            ->where('invoice_return_product.deleted_at', '=', NULL)
            ->groupBy('invoice_return_product.id')
        ;

        //user 35
        $user = Auth::user();
        $rep = '';

        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $invoice_returns->where('customer_type', '35');
        }

        if (!empty($filters['date_range'])) {

            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $formatted_from_date = Carbon::parse($from_date)->format('Y-m-d');
            $formatted_end_date = Carbon::parse($end_date)->format('Y-m-d');
            $invoice_returns->whereBetween('invoice_return.invoice_return_date', [$formatted_from_date, $formatted_end_date]);

        }

        if (!empty($filters['invoice_rep'])) {
            $rep_id = $filters['invoice_rep'];
            // $invoice_returns = $invoice_returns->whereHas('invoice', function ($query) use ($rep_id) {
            //     $query->where('rep_id', $rep_id);
            // });
            $invoice_returns = $invoice_returns->where('invoice.rep_id', $rep_id);
            $rep_user = User::find($rep_id);
            $rep = $rep_user->fname . ' ' . $rep_user->lname;

        }

        if (!empty($filters['rep_id'])) {
            $rep_id = $filters['rep_id'];
            // $invoice_returns = $invoice_returns->whereHas('customer', function ($query) use ($rep_id) {
            //     $query->where('rep_id', $rep_id);
            // });
            $invoice_returns = $invoice_returns->where('customer.rep_id', $rep_id);
            $rep_user = User::find($rep_id);
            $rep = $rep_user->fname . ' ' . $rep_user->lname;
        }


        $invoice_returns = $invoice_returns->get();

        $parameters = array(
            'invoice_returns' => $invoice_returns,
            'from_date' => $formatted_from_date,
            'end_date' => $formatted_end_date,
            'rep' => $rep,

        );

        $pdf = \PDF::loadView('xreports::sales.goods_return_wise_summary.goods_return_wise_summary_report', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'goods_return_wise_summary_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/grn_return');
        return $path;
    }


    public function getDatesFromRange($start_date, $end_date, $date_format = 'Y-m-d')
    {
        $dates_array = [];
        $start_date = Carbon::parse($start_date);
        $end_date = Carbon::parse($end_date);

        while ($start_date <= $end_date) {
            $dates_array[] = $start_date->format($date_format);
            $start_date->addDay();
        }

        return $dates_array;
    }

    public function generatePaymentSummaryReportWise($filters)
    {
        $from_date = null;
        $end_date = null;
        $rep = null;
        $report_type = $filters['report_type'];
        $payments = InvoicePayment::join('invoice', 'invoice_payments.invoice_id', 'invoice.id')
            ->join('customer', 'customer.id', 'invoice.customer_id')
            ->where('invoice_payments.status', 1)
            ->select(
                'invoice_payments.id',
                'invoice_payments.rep_id',
                'invoice_payments.payment_code',
                'invoice_payments.payment_date',
                'invoice_payments.payment_amount',
                'invoice.rep_id',
                'invoice.user_type',
                'customer.rep_id'
            );

        $invoice_wise_payments = InvoicePayment::join('invoice', 'invoice_payments.invoice_id', 'invoice.id')
            ->join('customer', 'customer.id', 'invoice.customer_id')
            ->where('invoice_payments.status', 1)
            ->select(
                'invoice_payments.id',
                'invoice_payments.rep_id',
                'invoice_payments.payment_code',
                'invoice_payments.payment_date',
                'invoice_payments.payment_amount',
                'invoice.rep_id',
                'invoice.invoice_code',
                'invoice.user_type',
                'customer.rep_id'
            );


        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $date_range_details['from_date'];
            $end_date = $date_range_details['end_date'];
            $from_date = Carbon::parse($from_date)->format('Y-m-d');
            $end_date = Carbon::parse($end_date)->format('Y-m-d');
            $payments->whereBetween('payment_date', [$from_date, $end_date]);
            $invoice_wise_payments->whereBetween('payment_date', [$from_date, $end_date]);
        }
        $user = Auth::user();
        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $payments->where('user_type', '35');
            $invoice_wise_payments->where('user_type', '35');
        }
        if (!empty($filters['invoice_rep'])) {
            $rep_id = $filters['invoice_rep'];
            $payments->where('invoice.rep_id', $rep_id);
            $invoice_wise_payments->where('invoice.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        if (!empty($filters['payment_rep'])) {
            $rep_id = $filters['payment_rep'];
            $payments->where('invoice_payments.rep_id', $rep_id);
            $invoice_wise_payments->where('invoice_payments.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        if (!empty($filters['rep_id'])) {
            $rep_id = $filters['rep_id'];
            $payments->where('customer.rep_id', $rep_id);
            $invoice_wise_payments->where('customer.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;
        }
        // $payments = $payments->get();

        $payments = $payments->get()->toArray();
        $invoice_wise_payments = $invoice_wise_payments->get();

        // dd($payments);

        // Sort the array by invoice_return_date in ascending order
        usort($payments, function ($a, $b) {
            return strcmp($a['payment_date'], $b['payment_date']);
        });

        // Iterate over the sorted array and accumulate the total by date
        $results = [];
        $currentDate = null;
        $currentTotal = 0;
        foreach ($payments as $item) {
            if ($item['payment_date'] !== $currentDate) {
                if ($currentDate !== null) {
                    $results[] = [

                        'payment_date' => $currentDate,
                        'payment_amount' => $currentTotal
                    ];
                }
                $currentDate = $item['payment_date'];
                $currentTotal = 0;
            }
            $currentTotal += $item['payment_amount'];
        }

        // Add the last date's total to the results
        $results[] = [
            'payment_date' => $currentDate,
            'payment_amount' => $currentTotal
        ];


        $parameters = array(
            'payments' => $results,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'rep' => $rep,
        );

        $invoice_wise_parameters = array(
            'payments' => $invoice_wise_payments,
            'from_date' => $from_date,
            'end_date' => $end_date,
            'rep' => $rep,
        );


        if ($report_type == 'invoice_wise') {
            $pdf = \PDF::loadView('xreports::sales.payment_summary_invoice_wise.invoice_wise_payment_summary_report', $invoice_wise_parameters)
                ->setPaper('letter', 'portrait');
            $file_name = 'invoice_wise_payment_summary_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        } else {
            $pdf = \PDF::loadView('xreports::sales.daily_payment_summary.daily_payment_summary_report', $parameters)
                ->setPaper('letter', 'portrait');
            $file_name = 'daily_payment_summary_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        }
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/payment');
        return $path;
    }

    public function generateChequeReturnReport($filters)
    {
        // dd($filters);
        ;
        $from_date = null;
        $end_date = null;
        $city = null;
        $rep = null;
        $customer_name = null;


        $customers = Customer::join('cheque', 'cheque.customer_id', '=', 'customer.id')
            ->join('invoice', 'invoice.customer_id', '=', 'customer.id')
            ->join('users', 'customer.rep_id', '=', 'users.id')
            ->selectRaw(
                'DISTINCT pramix_customer.id AS customer_id,
                                pramix_customer.status AS customer_status,
                                pramix_customer.company_name AS customer_company_name,
                                pramix_customer.business_name AS customer_business_name,
                                pramix_customer.rep_id AS customer_rep,
                                pramix_cheque.status AS cheque_status,
                                pramix_customer.invoice_type AS customer_invoice_type,
                                pramix_cheque.cheque_return_date,
                                pramix_invoice.customer_id AS invoice_customer_id,
                                pramix_users.fname AS fname,
                                pramix_users.lname AS lname,
                                pramix_invoice.rep_id AS invoice_rep_id'
            )
            ->where('customer.status', 'A')
            ->where('cheque.status', 2);

        $user = Auth::user();
        if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
            $customers->where('customer.invoice_type', '35');
        }

        if (!empty($filters['date_range'])) {
            $date_range_details = ReportsModel::getReportTimeRange($filters);
            $from_date = $filters['date_from'];
            $end_date = $filters['date_to'];
            $from_date = Carbon::parse($from_date)->startOfDay();
            $end_date = Carbon::parse($end_date)->endOfDay();
            //problem is properly not ordering by date and no cheques date HAVE PROBLEM
            $customers->whereBetween('cheque.cheque_return_date', [$from_date, $end_date])->orderBy('cheque.cheque_return_date');
            // $customers->whereHas('cheques', function ($query) use ($from_date, $end_date) {
            //     $query->whereBetween('cheque_return_date', [$from_date, $end_date])->orderBy('cheque_return_date');
            // });

        }
        // area_id is empty in db
        // if (!empty($filters['city_id'])) {
        //     $city_id = $filters['city_id'];
        //     $customers->whereHas('cheques.invoice_payment.invoice.customer', function ($query) use ($city_id) {
        //         $query->where('area_id', $city_id);
        //     });
        //     $city = City::find($city_id)->name_en;
        // }

        if (!empty($filters['customer_id'])) {
            $customer_id = $filters['customer_id'];
            $customers->where('invoice.customer_id', $customer_id);
            // $customers->whereHas('cheques.invoice_payment.invoice', function ($query) use ($customer_id) {
            //     $query->where('customer_id', $customer_id);
            // });
            // dd($customers->get());
            $customer_name = Customer::find($customer_id)->company_name;

        }

        if (!empty($filters['rep_id'])) {
            $rep_id = $filters['rep_id'];
            $customers->where('customer.rep_id', $rep_id);
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;

        }


        if (!empty($filters['invoice_rep'])) {
            $rep_id = $filters['invoice_rep'];
            $customers->where('invoice.rep_id', $rep_id);
            // $customers->whereHas('cheques.invoice_payment.invoice', function ($query) use ($rep_id) {
            //     $query->where('rep_id', $rep_id);
            // });
            $user = User::find($rep_id);
            $rep = $user->fname . ' ' . $user->lname;

        }

        $customers = $customers->orderBy('customer.business_name')->groupBy('customer.id')->get();
        $customer_count = $customers->count();
        // dd($customers);
        // dd($customer_count);
        $from_date_display = Carbon::parse($from_date)->format('Y-m-d');
        $end_date_display = Carbon::parse($end_date)->format('Y-m-d');
        $parameters = array(
            'customers' => $customers,
            'from_date' => $from_date_display,
            'end_date' => $end_date_display,
            'city' => $city,
            'rep' => $rep,
            'customer_name' => $customer_name
        );
        $pdf = \PDF::loadView('xreports::sales.cheque_return.customer_wise_cheque_return_report', $parameters)
            ->setPaper('letter', 'portrait');
        $file_name = 'customer_wise_cheque_return_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';
        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales/cheque_return');
        return $path;
    }

    public function generateChequeReturnWiseReport($filters)
    {
        $from_date = null;
        $end_date = null;
        $rep = null;
        $report_type = $filters['report_type'];
        $cheques = null;


        if ($report_type == 'invoice_wise') {

            $cheques = ChequeModel::join('invoice_payments', 'invoice_payments.cheque_id', '=', 'cheque.id')
                ->join('invoice', 'invoice.id', '=', 'invoice_payments.invoice_id')
                ->join('customer', 'customer.id', '=', 'invoice.customer_id')
                ->where('cheque.status', 2)
                ->where('invoice_payments.status', 0)
                ->where('invoice_payments.parent_id', NULL)
                ->select(
                    'cheque.id',
                    'cheque.payment_ref_no',
                    'invoice_payments.payment_amount',
                    'cheque.cheque_date',
                    'cheque.cheque_return_date',
                    'cheque.cheque_return_date',
                    'invoice.invoice_code',
                    'invoice.user_type',
                    'invoice.rep_id as invoice_rep_id',
                    'customer.rep_id as customer_rep_id'
                );


            if (!empty($filters['date_range'])) {
                $date_range_details = ReportsModel::getReportTimeRange($filters);
                $from_date = $date_range_details['from_date'];
                $end_date = $date_range_details['end_date'];
                $from_date = Carbon::parse($from_date)->startOfDay();
                $end_date = Carbon::parse($end_date)->endOfDay();
                $cheques->whereBetween('cheque.cheque_return_date', [$from_date, $end_date]);
                // dd($cheques->get());
            }

            $user = Auth::user();
            if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
                $cheques->where('invoice.user_type', '35');
            }
            if (!empty($filters['invoice_rep'])) {
                $rep_id = $filters['invoice_rep'];
                $cheques->where('invoice.rep_id', $rep_id);

                $user = User::find($rep_id);
                $rep = $user->fname . ' ' . $user->lname;

            }
            if (!empty($filters['rep_id'])) {
                $rep_id = $filters['rep_id'];
                $cheques->where('customer.rep_id', $rep_id);
                $user = User::find($rep_id);
                $rep = $user->fname . ' ' . $user->lname;

            }


            $cheques = $cheques->get()->toArray();
            // dd($cheques);

            $cheque_details = [];
            $invoice_code = null;
            $cheque_id = null;
            $paymentTotal = 0;
            foreach ($cheques as $item) {
                if ($item['invoice_code'] !== $invoice_code) {
                    if ($invoice_code !== null) {
                        $cheque_details[] = [

                            'invoice_code' => $invoice_code,
                            'payment_amount' => $paymentTotal,
                            'cheque_id' => $cheque_id,
                        ];
                    }
                    $invoice_code = $item['invoice_code'];
                    $paymentTotal = 0;
                    $cheque_id = $item['id'];
                }
                $paymentTotal += $item['payment_amount'];
            }

            // Add the last date's total to the results
            $cheque_details[] = [
                'invoice_code' => $invoice_code,
                'payment_amount' => $paymentTotal,
                'cheque_id' => $cheque_id,
            ];

            $from_date_display = Carbon::parse($from_date)->format('Y-m-d');
            $end_date_display = Carbon::parse($end_date)->format('Y-m-d');
            $parameters = array(
                'cheques' => $cheque_details,
                'from_date' => $from_date_display,
                'end_date' => $end_date_display,
                'rep' => $rep,
            );

            $pdf = \PDF::loadView('xreports::sales.invoice_wise_cheque_return.invoice_wise_cheque_return_report', $parameters)
                ->setPaper('letter', 'portrait');
            $file_name = 'invoice_wise_cheque_return_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';


        } else {

            $cheques = ChequeModel::where('status', 2)
                ->select(
                    'id',
                    'payment_ref_no',
                    'payment_amount',
                    'cheque_date',
                    'cheque_return_date'
                );


            if (!empty($filters['date_range'])) {
                $date_range_details = ReportsModel::getReportTimeRange($filters);
                $from_date = $date_range_details['from_date'];
                $end_date = $date_range_details['end_date'];
                $from_date = Carbon::parse($from_date)->startOfDay();
                $end_date = Carbon::parse($end_date)->endOfDay();
                $cheques->whereBetween('cheque_return_date', [$from_date, $end_date]);
                // dd($cheques->get());
            }

            $user = Auth::user();
            if ($user->username == 'user35'|| $user->username == 'USER30@GMAIL.COM' || $user->username == 'USER33@GMAIL.COM') {
                $cheques->whereHas('invoice_payment.invoice', function ($query) {
                    $query->where('user_type', '35');

                });

            }
            if (!empty($filters['invoice_rep'])) {
                $rep_id = $filters['invoice_rep'];
                $cheques->whereHas('invoice_payment.invoice', function ($query) use ($rep_id) {
                    $query->where('rep_id', $rep_id);
                });
                $user = User::find($rep_id);
                $rep = $user->fname . ' ' . $user->lname;

            }
            if (!empty($filters['rep_id'])) {
                $rep_id = $filters['rep_id'];
                $cheques->whereHas('invoice_payment.invoice.customer', function ($query) use ($rep_id) {
                    $query->where('rep_id', $rep_id);
                });
                $user = User::find($rep_id);
                $rep = $user->fname . ' ' . $user->lname;

            }


            $cheques = $cheques->get();
            $from_date_display = Carbon::parse($from_date)->format('Y-m-d');
            $end_date_display = Carbon::parse($end_date)->format('Y-m-d');
            $parameters = array(
                'cheques' => $cheques,
                'from_date' => $from_date_display,
                'end_date' => $end_date_display,
                'rep' => $rep,
            );

            $pdf = \PDF::loadView('xreports::sales.daily_cheque_return.daily_cheque_return_report', $parameters)
                ->setPaper('letter', 'portrait');
            $file_name = 'daily_cheque_return_report_' . str_replace(['-', ' ', ':'], ['_', '_', '_'], Carbon::now()) . '.pdf';

        }



        $file = $pdf->output();
        $commonUtil = new CommonUtil();
        $path = $commonUtil->uploadFileToAWS($file_name, $file, 'cmk/reports/sales/cheque_return');
        return $path;
    }



}
