<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class InvoiceReturn extends Model
{
    protected $guarded = ['id'];
    protected $table = 'invoice_return';

    public function customer()
    {
        return $this->hasOne(Customer::class, 'id', 'customer_id');
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'created_by');
    }

    public function invoice_return_products()
    {
        return $this->hasMany(InvoiceReturnProduct::class, 'invoice_return_id', 'id');
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class, 'invoice_id', 'id');
    }

}
