<?php

namespace App\Http\Controllers;

use App\Customer;
use App\FileAttech;
use Illuminate\Http\Request;

class FileAttechController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($id)
    {
        $customer = Customer::find($id);
        $file = FileAttech::where('customer_id',$id)->first();

        return view('files.create' ,compact('customer', 'file'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request);
        $fileAttech = FileAttech::where('customer_id',$request->customer_id)->first();

        if(empty($fileAttech)){
        $fileAttech = FileAttech::create([
            'customer_id' => $request->customer_id
        ]);}
        $br = $request->file('br');
        if (!empty($br)) {
            $fileAttech->br = $this->fileUpload($br);
            $fileAttech->save();
        }
        $registration_form = $request->file('registration_form');
        if (!empty($registration_form)) {
            $fileAttech->registration_form = $this->fileUpload($registration_form);
            $fileAttech->save();
        }
        $nic_front = $request->file('nic_front');
        if (!empty($nic_front)) {
            $fileAttech->nic_front = $this->fileUpload($nic_front);
            $fileAttech->save();
        }
        $nic_back = $request->file('nic_back');
        if (!empty($nic_back)) {
            $fileAttech->nic_back = $this->fileUpload($nic_back);
            $fileAttech->save();
        }

        return redirect()->route('customer.index');

    }
    public function fileUpload($image)
    {
        $file_name = 'image' . date('YmdHis') . '.' . $image->getClientOriginalExtension();
        $image->move(public_path('storage/files'), $file_name);
        $product_image = 'storage/files/' . $file_name;
        return $product_image;
    }
    /**
     * Display the specified resource.
     *
     * @param  \App\FileAttech  $fileAttech
     * @return \Illuminate\Http\Response
     */
    public function show(FileAttech $fileAttech)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\FileAttech  $fileAttech
     * @return \Illuminate\Http\Response
     */
    public function edit(FileAttech $fileAttech)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\FileAttech  $fileAttech
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, FileAttech $fileAttech)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\FileAttech  $fileAttech
     * @return \Illuminate\Http\Response
     */
    public function destroy(FileAttech $fileAttech)
    {
        //
    }
}
