<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Spatie\Activitylog\Models\Activity;
use Yajra\DataTables\Facades\DataTables;

class AuditLogController extends Controller
{

    public function index()
    {
        return view('audit_log.index');
    }

    public function auditLogList(Request $request)
    {
        $log_types = [
            'created' => '<span class="badge badge-primary">Created</span>',
            'updated' => '<span class="badge badge-secondary">Updated</span>',
            'deleted' => '<span class="badge badge-danger">Deleted</span>'
        ];
        $activities = Activity::all();
        return DataTables::of($activities)
            ->editColumn('description', function ($activity) use ($log_types) {
                return $log_types[$activity->description];
            })
            ->editColumn('created_at', function ($activity) {
                return Carbon::parse($activity->created_at)->format('Y-m-d');
            })
            ->editColumn('causer_id', function ($activity) {
                return $activity->causer->user_full_name ?? 'N/A';
            })
            ->editColumn('properties', function($activity) {
                return view('audit_log.properties', compact('activity'));
            })
            ->rawColumns(['description', 'properties'])
            ->make(true);
    }
}
