<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Pramix\XPayment\Models\ChequeModel;

class Customer extends Model
{
    use SoftDeletes;

    protected $guarded = ['id'];
    protected $table = 'customer';
    protected $dates = ['deleted_at'];
    protected $fillable = ['outstanding_amount'];

    public function comments()
    {
        return $this->hasMany('Pramix\XCustomer\Models\CustomerCommentsModel', 'customer_id', 'id');
    }

    public function outstanding_invoices()
    {
        return $this->hasMany(Invoice::class, 'customer_id')->where('status', 'I')->whereColumn('total', '>', 'paid_amount');
    }

    public function invoices()
    {
        return $this->hasMany(Invoice::class, 'customer_id', 'id');
    }

    public function return_cheque_payments()
    {
        return $this->hasMany(ChequeReturnPayment::class, 'customer_id', 'id');
    }

    public function invoice_returns()
    {
        return $this->hasMany(InvoiceReturn::class, 'invoice_id', 'id')->where('status', 'A');
    }

    public function rep()
    {
        return $this->hasOne('Pramix\XUser\Models\User', 'id', 'rep_id');
    }
    public function area()
    {
        return $this->hasOne(City::class, 'id', 'area_id');
    }

    public function address()
    {
        return $this->hasMany(Address::class, 'ref_id', 'id')->where('user_type', 'C')->where('address_type', 'B');
    }

    public function cheques()
    {
        return $this->hasMany(ChequeModel::class, 'customer_id', 'id');
    }

    public function bulk_discounts()
    {
        return $this->hasMany(BulkDiscountModel::class);
    }

    public function customerPrivateAddress()
    {
        return $this->hasOne('Pramix\XGeneral\Models\AddressModel', 'ref_id', 'id')->where('user_type', 'C')->where('address_type', 'B');
    }

    public function getFullNameAttribute()
    {
        return $this->fname . ' ' . $this->lname;
    }

    public function getCompanyFullNameAttribute()
    {
        return $this->company_name . ' ' . $this->company_branch;
    }
}
