<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;

class DatabaseBackup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'db:create_backup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create an database backup';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // start the backup process
        Artisan::call('backup:run');
        $output = Artisan::output();
        // log the results
        Log::info("Backpack\BackupManager -- new backup started from admin interface \r\n" . $output);
    }
}
