<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ChequeReturnPayment extends Model
{
    protected $guarded = ['id'];
    protected $table = 'cheque_return_payments';

    public function user()
    {
        return $this->belongsTo(User::class, 'id', 'created_by');
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class, 'customer_id', 'id' );
    }

    public function cheque_return_payment_has_cheques()
    {
        return $this->belongsTo(ChequeReturnPaymentHasCheque::class, 'id', 'cheque_payment_id' );
    }

}
